<?php
/**
 * Handle_standbench.php - Search handle for standbench searches
 *
 * @author $Author: dtong $
 * @version $Id: Handle_standbench.php,v 1.25 2011/05/24 07:47:10 dtong Exp $
 * @copyright Copyright (c) 2009, Tiller Software Co., Ltd.
*/
if ( ! defined('BASEPATH')) exit('No direct script access allowed');
require_once('Handle_base.php');
require_once('display_list.php');

class Handle_standbench extends Handle_base{
	function __construct($params) {
		parent::__construct($params);
		$this->no_gensel_msg = lang('map_noselectmsg_gsub');
	}

	function process() {
		$sql_array = FALSE;
	 	$sql_array = $this->CI->searchsort_model->getSqlSession($this->get_inputvalue('_divid'));
		$session_type = FALSE;
		if ($sql_array != FALSE && isset($sql_array['type']) && $sql_array['type'] != FALSE) {
			$session_type = $sql_array['type'];
			$course_query = $sql_array['course_query'];
			$standards    = $sql_array['standards'];
			$benchmarks   = $sql_array['benchmarks'];
			$grades       = $sql_array['grades'];
			$sort_by      = $sql_array['sort_by'];
		} else {
			$course_query= $this->get_calendar_query();

			$standards   = $this->cleanSelections($this->get_requestvalue('_standard'));
			if ($standards === FALSE) {
				echo osa_ajaxmsg(lang('map_selectstandard_msg'));
				return;
			}
			$benchmarks  = $this->cleanSelections($this->get_requestvalue('_benchmark'));
			$grades      = $this->cleanSelections($this->get_requestvalue('_grades'));

			$sort_by     = $this->get_templatevalue('_sort');
		}

		$query= $this->CI->standbench_model->get_query($course_query, $standards , $benchmarks , $grades, $sort_by );
		$sql_array = array('course_query'=>$course_query,'standards'=>$standards,
					'benchmarks'=>$benchmarks,'grades'=>$grades,
					'sort_by'=>$sort_by,'query'=>$query);

		$this->CI->searchsort_model->setSqlSession($this->get_inputvalue('_divid'), $sql_array);
		$res = $this->CI->standbench_model->run_query($query);

		$display = & $this->get_display_obj();
		$pagetitle = $this->get_templatevalue('_title');
		// for switch 3 style (normal,standard and standard+benchmark)
		$set_data = array('_pagetitle'=>$pagetitle, '_standard'=>$standards, '_benchmark'=>$benchmarks);
		$set_data = $this->CI->standbench_model->set_titlename($set_data);

		$display->pagetitle = $set_data['_pagetitle'] ;
		//$display->titles = array(lang('map_grade'),lang('map_standard'),lang('map_benchmark'),lang('map_learningtarget') );
		//$display->titles = array(lang('map_benchmark'),lang('map_learningtarget'),lang('map_grade'));
		//Set the size for each TD
		//$display->widths = array('10%','20%','20%','50%');

		$display->divid = $this->get_inputvalue('_divid');
		//$display->closebutton = TRUE; //divid has to be defined for this to work

		if ($session_type==FALSE)
			$session_type = CMS_MAPPING_NORMAL;

		$button_property['disable'] = $this->set_array();
		//$button_property['class']   = $this->set_array('btn');

		$button_property['disable'][$session_type] = 'disabled="disabled" style="color:grey"';
		//$button_property['class'][$session_type]   = 'dis';

		switch ($session_type) {
			case CMS_MAPPING_NORMAL:
				$this->big_default($res, $display);
				break;
			case CMS_MAPPING_COURSE:
				$this->big_course_grade($res, $display);
				break;
			case CMS_MAPPING_GRADE:
				$this->big_course_grade($res, $display, TRUE);
				break;
		}
		$display->button = $button_property;

		//Column titles can be very long so nobr tags
		$display->title_nobr = FALSE;
      $display->col_align_top = TRUE;
		$this->load_view($display);
	}

	private function set_array($default=''){
		$result = array(CMS_MAPPING_NORMAL=>$default,
					    CMS_MAPPING_COURSE=>$default,
						CMS_MAPPING_GRADE=>$default);
		return $result;
	}
	private function big_default($res, $display){
		$last_grade     = '';
		$last_benchmark = '';
		$_skip_benchmark = $this->get_templatevalue('_skip_benchmark');
		if ($this->CI->config->item('cms_hide_benchmarks') || $_skip_benchmark){
			$titles_array = array(lang('map_learningtarget'),lang('map_grade'),lang('map_course'));
			$widths_array = array('60%','20%','20%');
		}
		else{
			$titles_array = array(lang('map_benchmark'),lang('map_learningtarget'),lang('map_grade'),lang('map_course'));
			$widths_array = array('25%','55%','10%','10%');
		}

		$comma  = '&#8226; ';
		$target = '';
		$data   = FALSE;
		$chk_target = array();

		if ( $res ) {
			foreach ( $res as $item ) {
				if ($last_benchmark == '' || $last_benchmark != $item->benchmarkid || $last_grade != $item->gradeid) {
					if (is_array($data)) {
						$display->add($data);
						$data = FALSE;
					}
					$last_benchmark  = $item->benchmarkid;
					$last_grade      = $item->gradeid;
					$target	         = '';
				}
				$target .= $comma . $item->target . '<br />';
				if ($this->CI->config->item('cms_hide_benchmarks') || $_skip_benchmark){
					$data = array($target, $item->grade_name, $item->course_name );
				}
				else{
					$data = array($item->benchmark,  $target, $item->grade_name, $item->course_name );
				}

			}
			$display->add($data);
		}
		//Set the size for each TD
		$display->widths = $widths_array;
		$display->titles = $titles_array;

		return $display;
	}

	private function big_course_grade($res, $display, $flag_grade=FALSE){
		$_skip_benchmark = $this->get_templatevalue('_skip_benchmark');
		if ($this->CI->config->item('cms_hide_benchmarks') === FALSE || $_skip_benchmark === FALSE)
			$titles_array = array(lang('map_benchmark'));
		//$widths_array = array('25%');
		$comma  = '&#8226; ';
		$target = '';
		$data   = FALSE;

		$benchs_array = array();
		$target_array = array();
		$column_array = array();

		$column_id   = '';
		$column_name = '';
		$field_check = '';
		if ($flag_grade==FALSE) {
			$column_id   = 'courseid';
			$column_name = 'course_name';
		}
		else {
			$column_id   = 'gradeid';
			$column_name = 'grade_name';
		}

		$chk_target = array();
		$column_count = 1;
		if ( $res ) {
			foreach ( $res as $item ) {
				if ( !in_array($item->benchmarkid, $benchs_array) ) {
					$benchs_array[] = $item->benchmarkid;
					$target_array[$item->benchmarkid][0] = $item->benchmark;
				}

				if ( !in_array($item->$column_id, $column_array) ) {
					$column_array[] = $item->$column_id;
					//$widths_array[] = '25%';
					$column_count++;

					if ($flag_grade==FALSE) {
						$titles_array[] = lang('map_bp_course_column') . $item->$column_name;
					} else {
						if (is_numeric($column=str_replace('grade','',strtolower($item->$column_name))))
							$titles_array[] = lang('map_bp_grade_column') .$column;
						else
							$titles_array[] = $item->$column_name;
					}
				}

				if ( !in_array($item->benchmarkid.' '. $item->$column_id .' '. $item->targetid, $chk_target) ) {
					$chk_target[] =   ($item->benchmarkid.' '. $item->$column_id .' '. $item->targetid);
					$target_array[$item->benchmarkid][$item->$column_id][] =  $comma . $item->target . '<br />';
				} else
				{
					//var_dump($item->benchmarkid.' '. $item->$column_id .' '. $item->targetid);
				}
				//normal not check duplication
				//$target_array[$item->benchmarkid][$item->$column_id][] =  $comma . $item->target . '<br />';
			}
			//var_dump($chk_target);
			foreach ( $target_array as $benchmark ) {
				if (is_array($benchmark)) {
					$data = array();
					if ($this->CI->config->item('cms_hide_benchmarks') === FALSE || $_skip_benchmark === FALSE )
						$data = array($benchmark[0]);
					foreach ( $column_array as $columnid) {
						$targets = '';
						if (isset($benchmark[$columnid])) {
							foreach ( $benchmark[$columnid] as $target ) {
									$targets .= $target;
							}
						}
						else
							$targets .= '&nbsp;';

						$data[] = $targets;
					}
					$display->add($data);
				}
			}
		}
		$column_width = (int) (100 / $column_count);
		$widths_array = array();
		for ($i=0; $i<$column_count; $i++)
			$widths_array[] = "{$column_width}%";
		$display->widths = $widths_array;
		$display->titles = $titles_array;

		return $display;
	}
}
?>