<?php
/**
 * Handle_publishunit.php - Search handle for publishunit
 *
 * @author $Author: dtong $
 * @version $Id: Handle_publishunit.php,v 1.20 2011/04/11 12:02:16 dtong Exp $
 * @copyright Copyright (c) 2009, Tiller Software Co., Ltd.
*/
if ( ! defined('BASEPATH')) exit('No direct script access allowed');
require_once('Handle_base.php');
require_once('display_list.php');

class Handle_publishunit extends Handle_base{
	function __construct($params) {
		parent::__construct($params);
	}

	function process() {
		$user = $this->CI->login_model->getLogin();
		$display = & $this->get_display_obj();
		$display->column_data_align[2] = 'center';
		$status = $this->get_requestvalue('_sortorder');
		$query = FALSE;
		$res = FALSE;

		//Default display set up for edit and publish searches
		$display->titles = array(lang('map_course'),lang('map_unit'),lang('map_history')
										,lang('map_publishdate'));
		$title = lang('map_publish_unit_result');
		$display->widths = array('27%','45%','14%','10%');
		if ($status==CMS_UNIT_STATUS_ALL){
			$display->titles = array(lang('map_course'),lang('map_unit'),lang('map_history'),
			 								lang('map_status'),lang('map_date'));
			$title = lang('map_all_unit');
			$display->widths = array('26%','35%','15%','10%','10%');
			$query = $this->get_calendar_query(TRUE, TRUE, array(CMS_UNIT_STATUS_PUBLISH, CMS_UNIT_STATUS_EDIT));
		}
		elseif ($status==CMS_UNIT_STATUS_PUBLISH){
			$query = $this->get_calendar_query(TRUE, TRUE, array(CMS_UNIT_STATUS_PUBLISH));
		}
		elseif ($status==CMS_UNIT_STATUS_EDIT){
			$query = $this->get_calendar_query(TRUE, TRUE, array(CMS_UNIT_STATUS_EDIT));
		}

		if ( $query )
			$res = $this->CI->publishunit_model->run_query($query);

		$display->pagetitle=$title;
		$display->divid = $this->get_inputvalue('_divid');
		$version_array = $this->CI->publishunit_model->get_max_versions();

		//$no_compare_html = "<div class='mapping_nounitcompare'>".lang('map_no_history')."</div>";
		$no_compare_html = lang('map_no_history');
		if ( $res ) {
			$this->add_urllink_template_str(1, $display);
			$this->add_urllink_template_str(2, $display, $this->get_compare_link());
			foreach ( $res as $item ) {
				$needs_compare_data = TRUE;
				//This is very expensive DB calls that can be looped many times, very bad!
				//$data_group = $this->CI->unit_model->get_unit_any($item->id);
				//$data  = $this->CI->unit_model->get_unit_history($data_group,TRUE);
				$has_compare = FALSE;
				//Use the result from the version query to determine is there compare available or not
				if ( array_key_exists($item->groupid, $version_array) ) {
					$version = $version_array[$item->groupid];
					//unit.version is null for edit units and published units
					if ( $version->version_count > 2 ||
						  ($item->status == CMS_UNIT_STATUS_PUBLISH && ($version->version_count >= 1) && $version->max_version != NULL ) ||
						  ($item->status == CMS_UNIT_STATUS_EDIT && $version->version_count > 1)) {
							$has_compare = TRUE;
							/*
							$url_compare = base_url() . "unit/compare/current/{$item->id}";
							$unit_compare = "<span class='mapping_unitcompare'><a class=\"mapping_unitcompare\" href=\"$url_compare\"
													onclick=\"newDhtmlWindow('$url_compare','" . lang('map_unitcompare_title') .
													"',900,800,'compare');return false;\"><div class='mapping_unitcompare'>
													".lang('map_unitcompare_display')."</div></a></span>";*/
							$unit_compare = lang('map_unitcompare_display');
						}
				}

				//Check to make sure the user has edit access to determine should we show the compare link for a editing unit
				if ($item->status==CMS_UNIT_STATUS_EDIT){
					//course_model->isMyCourse() uses cache so it is ok to call this many times in the loop
					$canedit = $this->_iseditor($item->courseid, $user);
					if ( !$canedit ){
						$unit_compare = $no_compare_html;
						$needs_compare_data = FALSE;
					}
				}

				//Let's see what unit status is each unit and handle properly
				if($item->status==CMS_UNIT_STATUS_PUBLISH){
					$datastatus= lang('map_publish_unit');
					if(!$has_compare){
						$unit_compare = $no_compare_html;
						$needs_compare_data = FALSE;
					}
					$tmp_date = osa_date_format($item->modifydate);
				}
				else if($item->status==CMS_UNIT_STATUS_EDIT){
					$datastatus= lang('map_edit_unit');
					if(!$has_compare){
						$unit_compare = $no_compare_html;
						$needs_compare_data = FALSE;
					}
					//edit_accessdate was added for unit locking and some older units don't have it
					//so use editdate when it is not available. editdate is when turnedit on was invoked.
					//edit_accessdate is the very last time the user look at the editing unit page
					if ( $item->edit_accessdate != NULL )
						$tmp_date = osa_date_format($item->edit_accessdate);
					else
						$tmp_date = osa_date_format($item->editdate);
				}
				else {
					//This should not happen but just in case
					continue;
				}
				$unittitle = $item->title;
				if ($status==CMS_UNIT_STATUS_ALL)
					$data = array($item->coursename, $unittitle, $unit_compare, $datastatus, $tmp_date);
				else
					$data = array($item->coursename, $unittitle, $unit_compare, $tmp_date);

				if ( ($item->status == CMS_UNIT_STATUS_EDIT && $canedit) ||  $item->status != CMS_UNIT_STATUS_EDIT) {
					$this->add_hidden_data(1, $data, "'$item->id','$item->id'");
				}
				if ( $needs_compare_data ) {
					$this->add_hidden_data(2, $data, "'$item->id','$item->id'");
				}
				$display->add($data);
			}
		}
		$this->load_view($display);
	}

	private function _iseditor($courseid, $user) {
		$canedit = $this->CI->course_model->isMyCourse($user->id,$courseid);
		if ( !$canedit )
			$canedit = $this->CI->access_model->checkaccess_any('admin_course_description_write', $user, FALSE, FALSE);
		return $canedit;
	}
}