<?php
/**
 * Handle_orphanlt.php - Search handle for orphan learning targets search
 *
 * @author $Author: dtong $
 * @version $Id: Handle_orphanlt.php,v 1.13 2011/04/11 12:02:16 dtong Exp $
 * @copyright Copyright (c) 2009, Tiller Software Co., Ltd.
*/
require_once('Handle_base.php');
require_once('display_list.php');

class Handle_orphanlt extends Handle_base{
	function __construct($params) {
		parent::__construct($params);
		$this->CI->load->model('mapping/orphanlt_model');
	}

	function process() {
		$course_query = $this->get_calendar_query();
		$res = $this->CI->orphanlt_model->get($course_query);
		//var_dump($res);
		$display = & $this->get_display_obj();
		$display->pagetitle = $this->get_templatevalue('_title');

		if ( ($benchmark_title = $this->get_templatevalue('_benchmark_title')) == FALSE )
			$benchmark_title = lang('map_benchmark');
		if ( ($target_title = $this->get_templatevalue('_target_title')) == FALSE )
			$target_title = lang('map_target');

		$skip_standard = $this->get_templatevalue('_skip_standard');
		$skip_benchmark = $this->CI->config->item('cms_hide_benchmarks');

		$display->titles = array(lang('map_course'));
		$display->widths = array('15%');
		if ( $skip_standard ) {
			if ( !$skip_benchmark ) {
				$display->titles[] = $benchmark_title;
				$display->widths[] = '50%';
			}

			$display->titles[] = $target_title;
			$display->widths[] = '35%';
		}
		else {
			$display->titles[] = lang('map_standard');
			$display->widths[] = '20%';

			if ( !$skip_benchmark ) {
				$display->titles[] = $benchmark_title;
				$display->widths[] = '35%';
			}
			$display->titles[] = $target_title;
			$display->widths[] = '30%';

		}

		$display->divid = $this->get_inputvalue('_divid');
		//$display->closebutton = TRUE; //divid has to be defined for this to work
		if ( $res ) {
			foreach ( $res as $item ) {

				$data = array($item->coursename);
				if ( !$skip_standard )
					$data[] = $item->standard;

				if ( !$skip_benchmark )
					$data[] = $item->benchmark;

				$data[] = $item->target;

				$display->add($data);
			}
		}
		$this->load_view($display, FALSE);
	}
}
?>