<?php
/**
 * Handle_lthistory.php - Search handle for handling ICT tech lib searches
 *
 * @author $Author: dtong $
 * @version $Id: Handle_lthistory.php,v 1.18 2011/04/11 12:02:16 dtong Exp $
 * @copyright Copyright (c) 2009, Tiller Software Co., Ltd.
*/
require_once('Handle_base.php');
require_once('display_list.php');

class Handle_lthistory extends Handle_base{

	private $tech = array();
	private $lib = array();
	private $techlib = array();

	function __construct($params) {
		parent::__construct($params);
		$this->CI->load->model('mapping/lthistory_model');
		$this->CI->load->library('admin/admin_base');
	}

	function process() {
		$course_query = $this->get_calendar_query();
		$type = $this->get_requestvalue('_sortorder');
		$hist_type = $this->get_requestvalue('_hist_type');
		// this get_requestvalue from template date
		if ($type==CMS_LT_HIST_All){
			$monthfrom = $this->get_requestvalue('_month_selected');
			$yearfrom = $this->get_requestvalue('_year_selected');
			$monthto = $monthfrom;
			$yearto = $yearfrom;
		}
		elseif ($type==CMS_LT_HIST_LAST){
			$monthfrom = $this->get_requestvalue('_month_from');
			$yearfrom = $this->get_requestvalue('_year_from');
			$monthto = $this->get_requestvalue('_month_to');
			$yearto = $this->get_requestvalue('_year_to');
		}

		$display = & $this->get_display_obj();
		$_skip_benchmark = $this->get_templatevalue('_skip_benchmark');


		if ($type==CMS_LT_HIST_All){
			if ($this->CI->config->item('cms_hide_benchmarks') || $_skip_benchmark){
				$display->titles = array(lang('map_course'),lang('map_lt_history_col_current_lt')
											,lang('map_lt_history_col_ks_current'),lang('map_lt_history_col_lt_history'));
				$title = lang('map_lt_history_all_title');
				$display->widths = array('10%','26%','5%','40%');
			}
			else{
				$display->titles = array(lang('map_course'),lang('map_benchmark'),lang('map_lt_history_col_current_lt')
											,lang('map_lt_history_col_ks_current'),lang('map_lt_history_col_lt_history'));
				$title = lang('map_lt_history_all_title');
				$display->widths = array('10%','17%','17%','5%','32%');
			}

		}
		elseif ($type==CMS_LT_HIST_LAST){
			if ($this->CI->config->item('cms_hide_benchmarks') || $_skip_benchmark){
				$display->titles = array(lang('map_course'),lang('map_lt_history_col_current_lt')
											,lang('map_lt_history_col_lt_history'),lang('map_lt_history_col_ks_current')
											,lang('map_lt_history_col_ks_history'),lang('map_lt_history_col_date'));
				$title = lang('map_lt_history_last_title');
				$display->widths = array('20%','33%','33%','5%','5%','10%');
			}
			else{
				$display->titles = array(lang('map_course'),lang('map_benchmark'),lang('map_lt_history_col_current_lt')
											,lang('map_lt_history_col_lt_history'),lang('map_lt_history_col_ks_current')
											,lang('map_lt_history_col_ks_history'),lang('map_lt_history_col_date'));
				$title = lang('map_lt_history_last_title');
				$display->widths = array('20%','20%','23%','23%','5%','5%','10%');
			}
		}

		$res = $this->CI->lthistory_model->get($course_query, $type,$monthfrom,$yearfrom,$monthto,$yearto,$hist_type);
		$display->divid = $this->get_inputvalue('_divid');
		$display->pagetitle=$title;

		if ( $res ) {
			$data = FALSE;
			$comma='&#8226; ';
			$last_lt = '';
			$ks_hist = '';
			$lt_history = '';
			$ks_array = array('' => lang('map_lt_history_row_null'),CMS_LT_HIST_K => lang('map_lt_history_row_k'),
									CMS_LT_HIST_S => lang('map_lt_history_row_s'));
			$this->add_urllink_template_str(0, $display, $this->get_courselt_link());
			foreach ( $res as $item ) {
				/*
				$url_lnk = 'course/target/index_hist/'.$item->courseid;
				$title_lnk = lang('map_lt_history_lnk_title');
				$width = '1000';
				$height = '750';
				$div = 'lt_form';
				$img_title = lang('map_lt_history_img_title');
				$coursename = $this->CI->admin_base->linkDhtmlWindow($url_lnk, $title_lnk, $width, $height, $div ,$item->course,$img_title);
				*/
				$benchmark = $item->benchmark;
				$ks_current= $item->ks_current;
				$history_date = '('.osa_date_format($item->hist_date).')';
				$ks = '<div class="lt_history_ks">'.$ks_array[$item->ks].'</div>';
				$current = $item->data;
				if($item->data=='')
					$current = lang('map_lt_history_row_null');

				if ($last_lt != '' && $last_lt != $item->ltid) {
					$last_lt = '';
					$ks_hist = '';
					$current_lt = '';
					$lt_history = '';
					if ( $data ) {
						$this->add_hidden_data(0, $data, "'$last_courseid','$last_courseid'");
						$display->add($data);
					}
				}

				if ($last_lt == '' && $last_lt != $item->ltid) {
					// new lt.
					if ($item->ks_history !=''){
						if($item->ks!=$item->ks_history){
							$ks_hist =  '<div class="lt_history_ks">'. $ks_array[$item->ks_history] .'</div>';
						}
						else{
							$ks_hist =  '<div class="lt_history_ks">'.lang('map_lt_history_row_null') .'</div>';
						}
					}
					else{
						$ks_hist =  '<div class="lt_history_ks">'.lang('map_lt_history_row_null') .'</div>';
					}

					$last_lt = $item->ltid;
					$current_lt = $item->current_lt;
					$history_lt = $item->lt_history;

					if ($type==CMS_LT_HIST_LAST){
						$history_datelast = osa_date_format($item->hist_date);
						$lt_history = $this->history_last($item->hist_type,$lt_history,$item->data,$item->current_lt,
															       $item->lt_history,$history_date,$item->lt_history,$ks_array[$item->ks_history]);
					}

				}
				if ($type==CMS_LT_HIST_All){
					$lt_history = $this->history_all($item->hist_type,$lt_history,$comma,$type,$item->data,$item->current_lt,
															   $item->ks_current,$item->lt_history,$item->ks_history,$history_date,$item->ks,
															   $item->lt_history,$ks_array[$item->ks_history]);
				}

				if($item->ks!=''){
					if ($item->ks==CMS_LT_HIST_K){
						$ks_current = '<div class="lt_history_ks">'.$ks_array[$item->ks].'</div>';
					}
					elseif ($item->ks==CMS_LT_HIST_S){
						$ks_current = '<div class="lt_history_ks">'.$ks_array[$item->ks].'</div>';
					}
				}
				else{
					$ks_current = '<div class="lt_history_ks">'.lang('map_lt_history_row_null').'</div>';
				}

				if ($type==CMS_LT_HIST_All){
					if ($this->CI->config->item('cms_hide_benchmarks') || $_skip_benchmark){
						$data = array($item->course, $current, $ks, $lt_history);
					}
					else{
						$data = array($item->course, $benchmark,$current, $ks, $lt_history);
					}

				}
				elseif ($type==CMS_LT_HIST_LAST){
					if ($this->CI->config->item('cms_hide_benchmarks') || $_skip_benchmark){
						 $data = array($item->course, $current, $lt_history, $ks_current, $ks_hist,$history_datelast);
					}
					else{
						 $data = array($item->course, $benchmark,$current, $lt_history, $ks_current, $ks_hist, $history_datelast);
					}

				}
				$last_courseid = $item->courseid;
			} //foreach
		}

		if ($res != FALSE && is_array($res)) {
			$this->add_hidden_data(0, $data, "'$last_courseid','$last_courseid'");
			$display->add($data);
		}
		$this->load_view($display);
	}

	private function history_all($hist_type,$lt_history,$comma,$type,$data,$current_lt,$ks_current,$history_lt,$ks_history,$history_date,
										  $ks,$del_data,$del_sel) {
		switch ($hist_type) {
		        	case CMS_LT_HIST_ADD_TYPE:
						if ($data==$del_data)
							$del_data = lang('map_lt_history_row_current_lt');
						if ($ks_history==$ks)
							$del_sel = lang('map_lt_history_row_current_ks');
		        		$lt_history .=$comma .lang('map_lt_history_row_add').': '.$del_data .' '.lang('map_lt_history_row_And').' '.
		        						  $del_sel.' '.$history_date . '<br />';
				        break;
			        case CMS_LT_HIST_MODIFY_TYPE:
			        	$source = '';
			        	$target = '';
			        	$group = FALSE;
			        	$andselect = '';
				        	if($current_lt != '' && $ks_current !=''){
								if ( $ks_history == CMS_LT_HIST_S && $ks_current == CMS_LT_HIST_K) {
									$source = lang('map_lt_history_row_s');
									$target = lang('map_lt_history_row_k');
									if ($ks==$ks_current)
										$target = lang('map_lt_history_row_current_ks');
									$andselect = lang('map_lt_history_row_And').' '.
											   	 $source  .lang('map_lt_history_row_from_to'). $target;
					        	}
								else if ( $ks_history == CMS_LT_HIST_K && $ks_current == CMS_LT_HIST_S)	{
									$source = lang('map_lt_history_row_k');
									$target = lang('map_lt_history_row_s');
									if ($ks==$ks_current)
										$target = lang('map_lt_history_row_current_ks');
									$andselect = lang('map_lt_history_row_And') .' '.
											       $source  .lang('map_lt_history_row_from_to'). $target;
								}
								if ($data==$current_lt)
										$current_lt = lang('map_lt_history_row_current_lt');
								$lt_history .= $comma . lang('map_lt_history_row_modify').': '. $history_lt  .lang('map_lt_history_row_from_to').
											   $current_lt .' '.$andselect .' '.$history_date . '<br />';
								$group = TRUE;
						   }
						   elseif($current_lt != ''){
								if ($data==$current_lt)
										$current_lt = lang('map_lt_history_row_current_lt');
								$lt_history .= $comma . lang('map_lt_history_row_modify').': '. $history_lt  .lang('map_lt_history_row_from_to').
											   $current_lt .' '.$history_date . '<br />';
			        	   }

							if ($group ==FALSE){
								if ( $ks_history == CMS_LT_HIST_S && $ks_current == CMS_LT_HIST_K) {
									$source = lang('map_lt_history_row_s');
									$target = lang('map_lt_history_row_k');
									if ($ks==$ks_current)
										$target = lang('map_lt_history_row_current_ks');
					        	}
								else if ( $ks_history == CMS_LT_HIST_K && $ks_current == CMS_LT_HIST_S)	{
									$source = lang('map_lt_history_row_k');
									$target = lang('map_lt_history_row_s');
									if ($ks==$ks_current)
										$target = lang('map_lt_history_row_current_ks');
								}
								else if ( $ks_history == '' && $ks_current == CMS_LT_HIST_K)	{
									$source = lang('map_lt_history_row_null');
									$target = lang('map_lt_history_row_k');
									if ($ks==$ks_current)
										$target = lang('map_lt_history_row_current_ks');
								}
								else if ( $ks_history == '' && $ks_current == CMS_LT_HIST_S)	{
									$source = lang('map_lt_history_row_null');
									$target = lang('map_lt_history_row_s');
									if ($ks==$ks_current)
										$target = lang('map_lt_history_row_current_ks');
								}

								if ($source != '' && $target != '') {
									$lt_history .= $comma . lang('map_lt_history_row_modify').': ';
									$lt_history .= $source  .lang('map_lt_history_row_from_to'). $target;
									$lt_history .= ' ' . $history_date . '<br />';
								}
							}

				        break;
			        case CMS_LT_HIST_DELETE_TYPE:
			        	$lt_history .=$comma .lang('map_lt_history_row_delete').': '.$del_data .' '.lang('map_lt_history_row_And').' '.
			        					  $del_sel.' '.$history_date . '<br />';
				        break;
		}
		return $lt_history;
	}
	private function history_last($hist_type,$lt_history,$data,$current_lt,$history_lt,$history_date,$del_data,$del_sel) {
		switch ($hist_type) {
		        	case CMS_LT_HIST_ADD_TYPE:
		        		if ($data==$del_data)
							$del_data = lang('map_lt_history_row_current_lt');
		        		$lt_history .=lang('map_lt_history_row_add').': '.$del_data . '<br />';
				        break;
			      case CMS_LT_HIST_MODIFY_TYPE:
						  if($current_lt != ''){
						  	   $lt_history .= $history_lt ;
			        	   }
			        	   else{
			        	   	$lt_history .= lang('map_lt_history_row_null');
			        	   }
				        break;
			      case CMS_LT_HIST_DELETE_TYPE:
			        	  $lt_history .=lang('map_lt_history_row_delete').': '.$del_data ;
				        break;
		}
		return $lt_history;
	}

}
?>