<?php
/**
 * Handle_eq.php - Search handle for eq searches
 *
 * @author $Author: dtong $
 * @version $Id: Handle_eq.php,v 1.16 2011/04/11 12:02:16 dtong Exp $
 * @copyright Copyright (c) 2009, Tiller Software Co., Ltd.
*/
if ( ! defined('BASEPATH')) exit('No direct script access allowed');
require_once('Handle_base.php');
require_once('display_list.php');

class Handle_eq extends Handle_base{
	function __construct($params) {
		parent::__construct($params);
		$this->CI->load->model('mapping/eq_model');
		$this->no_gensel_msg = lang('map_noselectmsg_gsub');
	}

	function process() {
		$skip_eu = $this->get_templatevalue('_skip_enduring_understandings');

	   $course_query = $this->get_calendar_query();
	   $departments  = $this->cleanSelections($this->get_requestvalue('_departments'));
		$essentials   = $this->cleanSelections($this->get_requestvalue('_essential'));

		$essential   = $this->get_first_value($essentials);
		if ($essential === FALSE) {
			echo osa_ajaxmsg(lang('map_selecteq_msg'));
			exit;
		}
		$department  = $this->get_first_value($departments);

		$query = $this->CI->eq_model->get_query($course_query, $essential, CMS_TEACHER_EQ_TYPE);
		$query_eu = $this->CI->eq_model->get_query($course_query, $essential,  CMS_ENDURING_RES_TYPE);
		if ( $query == FALSE || $query_eu == FALSE ) {
			echo osa_ajaxmsg(lang('gen_internalservererror'));
			exit;
		}

		$res = $this->CI->eq_model->run_query($query);
		$res_eu = FALSE;
		if ( $skip_eu === FALSE ) {
		$res_eu = $this->CI->eq_model->run_query_array('unitid',$query_eu);
		}

		$display = & $this->get_display_obj();
		$pagetitle = $this->get_templatevalue('_title');

		if ($department != FALSE) {
			$res_dp = $this->CI->eq_model->get_department($department);
			//var_dump($res_dp);
			if ($res_dp)
				$pagetitle = $res_dp->name;
		}

		if ($essential != FALSE) {
			$res_eq = $this->CI->eq_model->get_essentials($department, $essential);
			//var_dump($res_eq);
			if ($res_eq)
				$pagetitle .= '/' . $res_eq->data;
		}

		$display->pagetitle = $pagetitle;

		//Set the size for each TD
		if ( $skip_eu === FALSE ) {
		$display->widths = array('10%','10%','15%','25%','40%');
		}
		else {
			$display->widths = array('20%','20%','25%','35%');
		}

		if ( $skip_eu === FALSE ) {
			$extend_titles = array( lang('map_eq_teacheq'),lang('map_eq_eu') );
		}
		else {
			$extend_titles = array( lang('map_eq_teacheq') );
		}
		$display->titles = array(lang('map_eq_course'),lang('map_eq_unit'),lang('map_eq_unitdesc')) ;
		$display->titles = array_merge($display->titles , $extend_titles);

		$display->divid = $this->get_inputvalue('_divid');
		//$display->closebutton = TRUE; //divid has to be defined for this to work
		if ( $res ) {
			$lastrid = '';
			$lastunitid = ''; $comma='&#8226; ';
			$desc_teq = '';
			$desc_eu  = '';
			$sub_comma=$comma;
			$flag = '';
			$this->add_urllink_template_str(1, $display);
			//This loop will consolidate the different selections from the same units into one entry
			foreach ( $res as $item ) {
				if ( $lastunitid == '' ) {
					$lastunitid = $item->unitid;
				}
				if ( $lastunitid != $item->unitid) {
					$this->add_hidden_data(1, $data, "'$lastunitid','$lastunitid'");
					$display->add($data);
					$lastunitid = $item->unitid;
					$desc_teq='';
					$desc_eu ='';
					$lastrid='';
					$comma='&#8226; ';
					$sub_comma = $comma;
					$flag = '';
				}
				if ( $flag == '' ) {
					if(isset($res_eu) && $res_eu != FALSE){
						if ( array_key_exists($item->unitid , $res_eu) ) {
							 $eu_item = $res_eu[$item->unitid];

							 if (is_array($eu_item)) {
							 	foreach ($eu_item as $value) {
								 	if ( $lastrid!= $value->rid) {
										 $lastrid = $value->rid;
								 	     $desc_eu  .= $sub_comma . $value->res_description;
								 	}
								 	$sub_comma = "<br />".$comma;
								 }
							 }
						}
					}
					$flag = $lastunitid;
				}

				$desc_teq .= $comma . $item->res_description;
				if ( $skip_eu === FALSE ) {
					$data = array($item->coursename , $item->unit_title, $item->description, $desc_teq, $desc_eu);
				}
				else {
					$data = array($item->coursename , $item->unit_title, $item->description, $desc_teq);
				}
				$comma='<br />&#8226; ';
			}
			$this->add_hidden_data(1, $data, "'$item->unitid','$item->unitid'");
			$display->add($data);
		}
		$this->load_view($display);
	}

	private function get_first_value($datas) {
		$value = FALSE;
		if (is_array($datas) ) {
			foreach ($datas as $value) {
				break;
			}
		}
		return $value;
	}
}
?>