<?php
/**
 * Handle_calendar.php - Search handle for calendar searches
 *
 * @author $Author: dtong $
 * @version $Id: Handle_calendar.php,v 1.14 2011/04/11 12:02:16 dtong Exp $
 * @copyright Copyright (c) 2009, Tiller Software Co., Ltd.
*/
if ( ! defined('BASEPATH')) exit('No direct script access allowed');
require_once('Handle_base.php');
require_once('display_list.php');

class Handle_calendar extends Handle_base{
	function __construct($params) {
		parent::__construct($params);
	}

	function process() {
		$query = $this->get_calendar_query(TRUE,TRUE);
		$res = $this->CI->calendar_model->run_query($query);
		$display = & $this->get_display_obj();
		$display->pagetitle = $this->get_templatevalue('_title');
		$display->titles = array(lang('map_course'),lang('map_unit'),lang('map_startdate'),
					 lang('map_enddate'),lang('map_description'));
		//Set the size for each TD
		$display->widths = array('16%','16%','10%','10%','48%');
		$display->divid = $this->get_inputvalue('_divid');

		if ( $res ) {
			$this->add_urllink_template_str(1, $display);
			foreach ( $res as $item ) {
				$data = array($item->coursename , $item->title, osa_date_format($item->startdate),
								  osa_date_format($item->enddate), $item->description);
				$this->add_hidden_data(1, $data, "'$item->id','$item->id'");
				$display->add($data);
			}
		}

		$sort_col = 0;
		$selected_col = $this->get_requestvalue('sortorder');
		if ( $selected_col !== FALSE && $selected_col != '0' ) {
			$sort_col = 2;
		}
		$display->default_col = $sort_col;
	   $this->load_view($display, TRUE);
	}
}
?>