<?php
/**
 * Handle_allunits.php - Search handle for all units
 *
 * @author $Author: dtong $
 * @version $Id: Handle_allunits.php,v 1.20 2011/04/14 05:41:43 dtong Exp $
 * @copyright Copyright (c) 2009, Tiller Software Co., Ltd.
*/
if ( ! defined('BASEPATH')) exit('No direct script access allowed');
require_once('Handle_base.php');
require_once('display_list.php');

class Handle_allunits extends Handle_base{
	function __construct($params) {
		parent::__construct($params);
		$this->CI->load->model('mapping/allunits_model');
		$this->no_gensel_msg = lang('map_noselectmsg_gsub');
	}

	function process() {
	   $course_query = $this->get_calendar_query();
	   $departments  = $this->cleanSelections($this->get_requestvalue('_departments'));
		$serch_words = $this->get_requestvalue('_allunits');

		if ( empty($serch_words) ) {
			echo osa_ajaxmsg(lang('map_allunits_error_text'));
			exit;
		}

		//put space delimetered words in an array and ignore words less than 3 characters
		$splits = $this->split($serch_words);
		$res = $this->CI->allunits_model->get($course_query, $splits);
		$display = & $this->get_display_obj();
		//Column 2 can have highloghted text so needs striptag
		$display->column_use_striptag[2] = TRUE;
		$display->column_use_striptag[3] = TRUE;
		$display->column_use_striptag[4] = TRUE;
		$pagetitle = $this->get_templatevalue('_title');
		$display->pagetitle = $pagetitle;
		//Set the size for each TD
		$display->widths = array('10%','10%','12%','28%','40%' );
		$display->titles = array(lang('map_allunits_subject'),lang('map_allunits_course'),
										 lang('map_allunits_unittitle'),lang('map_allunits_unitdesc'),lang('map_allunits_restext')) ;
		$display->divid = $this->get_inputvalue('_divid');

		if ( $res ) {
			$lastunitid = '';
			$combined_resources = '';
			$sep = '';
			$this->add_urllink_template_str(2, $display);
			//This loop will consolidate the different selections from the same units into one entry
			foreach ( $res as $item ) {
				if ( $lastunitid == '' ) {
					$lastunitid = $item->unitid;
				}
				if ( $lastunitid != $item->unitid) {
					////////////////// Same code
					$this->highlight($splits, $unit_title);
					$this->highlight($splits, $unitdesc);
					if ( $combined_resources != '' ) {
						$this->highlight($splits, $combined_resources, FALSE);
					}
					$data = array( $item->departmentname, $item->coursename, $unit_title, $unitdesc, $combined_resources );
					$this->add_hidden_data(2, $data, "'$lastunitid','$lastunitid'");
					$display->add($data);
					/////////////////
					$lastunitid = $item->unitid;
					$combined_resources = '';
					$sep = '';
				}
				//Find all the resources that contains at least one of the search words
				//and cancatenate them.
				foreach ( $splits as $searchword ) {
					if ( stripos($item->resource, $searchword) !== FALSE ) {
						$combined_resources .= $sep . $item->resource;
						$sep = '<hr style="width:80%" />';
						break;
					}
				}
				$unit_title = & $item->unit_title;
				$unitdesc = & $item->description;
			}
			$lastunitid = $item->unitid;
			////////////////// Same code
			$this->highlight($splits, $unit_title);
			$this->highlight($splits, $unitdesc);
			if ( $combined_resources != '' ) {
				$this->highlight($splits, $combined_resources, FALSE);
			}
			$data = array( $item->departmentname, $item->coursename, $unit_title, $unitdesc, $combined_resources );
			$this->add_hidden_data(2, $data, "'$lastunitid','$lastunitid'");
			$display->add($data);
			/////////////////
		}
		$this->load_view($display);
	}

	private function highlight($splits, &$string, $check_pos=TRUE) {
		foreach ($splits as $searchword) {
			//$string = str_ireplace( $str, '<font color="red"><b>'. $str . '</b></font>', $string )  ;
			$dohightligh = TRUE;
			if ( $check_pos ) {
				$dohightligh = FALSE;
				if ( stripos($string, $searchword) !== FALSE ) {
					$dohightligh = TRUE;
				}
			}
			if ( $dohightligh ) {
				$string = & preg_replace("/($searchword)/i", '<font color="red"><b>\1</b></font>', $string);
			}
		}
	}

	private function split($string) {
		if (empty($string))
			return FALSE;

		if ( $string[0] == '"' ) {
			return array(str_replace('"', '', $string));
		}

		if ( $string[0] == "'" ) {
			return array(str_replace("'", '', $string));
		}

		$split = FALSE;
		$split = explode(' ',$string);
		$result   = array();
		if ( !is_array($split) ) {
			return array($string);
		}

		foreach ($split as $str) {
			$str = trim($str);
			//Ignore words 2 characters or less
			if ( !empty($str) && strlen($str) > 2)
				$result[] = $str;
		}
		return $result;
	}
}
?>