<?php
/**
 * Osa_chart.php - Library to handle flash charts
 *
 * @author $Author: dtong $
 * @version $Id: Osa_chart.php,v 1.17 2011/04/27 05:46:27 dtong Exp $
 * @copyright Copyright (c) 2009, Tiller Software Co., Ltd.
*/

require_once('php-ofc-library/open-flash-chart.php');
require_once('Osa_chartdata.php');

Class Osa_chart {
	const LABLE_COLOR='#432BAF';
	const ALPHA_VALUE = 0.75;
	private $CI = NULL;
	public $data = NULL;
	//public $divid='flash_chart';

	function __construct() {
		$this->CI =& get_instance();
		$this->data = new Osa_chartdata();
	}

	/*
	 * The Jscript code for flash chart
	 */
	function js_include() {
		return osa_include_path() . 'js/flashchart/swfobject.js';
	}

	/*
	 * The Jscript code that renders the flash chart
	 */
/*
	function js_chartfunction($width=400, $height=300) {
		$url = urlencode(base_url() . "chart/chart/get/{$this->data->divid}");
		$flashobj = base_url() . "include/flashchart.swf";
		$divid = $this->data->divid;
		$js = "swfobject.embedSWF(" .
				"\"{$flashobj}\", \"{$this->data->divid}\"," .
				"\"{$width}\", \"{$height}\", \"9.0.0\", \"expressInstall.swf\"," .
				"{\"data-file\":\"{$url}\"});";
		return $js;
	}
*/
	/*
	 * Gets the data object
	 */
	function dataobj() {
		return $this->data;
	}

	function reset_data() {
		$this->data = new Osa_chartdata();
	}

	//Takes a data object and process the pie chart
	function prepare_pie() {
		$data = $this->data;
		$tmpnode = $data->nodehead;
		$slices = array();
		while ($tmpnode != NULL) {
			$tmpslice = new pie_value($tmpnode->value, $tmpnode->lable . " ({$tmpnode->value})");
			$tmpslice->set_colour('#' . $tmpnode->color);
			$tmpslice->on_click($tmpnode->link);
			$slices[] = $tmpslice;
			$tmpnode = $tmpnode->next;
		}
		$pie = new pie();
		$pie->set_animate( TRUE );
		$pie->set_label_colour( self::LABLE_COLOR );
		$pie->set_alpha( self::ALPHA_VALUE );
		//$pie->set_tooltip( '#label#<br>#val# (#percent#)' );
		$pie->set_tooltip( '#label#<br />#percent#' );
		$pie->set_values( $slices );
		$chart = new open_flash_chart();
		$chart->add_element( $pie );
		$result = $chart->toPrettyString();
		//echo $result;
		if ( $this->data->count > 0 )
			$this->CI->session->set_userdata('fc_' . $data->divid, $result);
		else
			$this->CI->session->set_userdata('fc_' . $data->divid, '{}');
		return $result; //Return value not used becuase the chart controller gets the data from the session
	}

	//TODO: This is unit specific and should not be here. The code should be specific to OFC only.
	function prepare_unit_barchart($data) {
		$chart = new open_flash_chart();
		$hbar = new hbar( '#32CD32' );
		$min_year = FALSE;
		$max_year = FALSE;
		$strlen = 0;
		//Let 's loop stratdate and enddate from unit
		$y_labels = array();
		$years_start = array();
		$years_finish = array();

		foreach ($data->unit as $unit){
			$time_s = strtotime($unit->startdate);
			$time_e = strtotime($unit->enddate);

			$temp = array();
			$temp['object'] = $unit;
			$temp['start']['date'] = $unit->startdate;
			$temp['start']['time'] = $time_s;
			$temp['start']['year'] = date('Y',$time_s );
			$temp['start']['month'] = date('m',$time_s );
			$temp['start']['day'] = date('d',$time_s );
			$temp['start']['all'] = date('Ymd',$time_s );

			$temp['end']['date'] = $unit->enddate;
			$temp['end']['time'] = $time_e;
			$temp['end']['year'] = date('Y',$time_e );
			$temp['end']['month'] = date('m',$time_e );
			$temp['end']['day'] = date('d',$time_e );
			$temp['end']['all'] = date('Ymd',$time_e );

			$times[] = $temp;

			if ($min_year==FALSE)
				$min_year = $time_s;
			elseif ($min_year >= $time_s)
				$min_year = $time_s;

			if ($max_year==FALSE)
				$max_year = $time_e;
			elseif ($max_year <= $time_e)
				$max_year = $time_e;

	 		$years_start[] =  $time_s;
	 		$years_finish[] =  $time_e;

		}

		foreach ($times as $time){
			$year_s = $time['start']['year'];
			$year_e = $time['end']['year'];
			$month_s = $time['start']['month'];
			$month_e = $time['end']['month'];
			$day_s = $time['start']['day'];
			$day_e = $time['end']['day'];

			// Get Total Day by Month
 			$day_total_s = $this->check_date($month_s,$year_s) ;
			$day_total_e = $this->check_date($month_e,$year_e) ;

			$time['start']['diff'] = ($year_s -  date('Y', $min_year)) * 12 ;
			$time['start']['diff'] += ( 12-date('m', $min_year)+1 ) - (12-$month_s) ;

			$time['end']['diff'] = ($year_e -  date('Y', $min_year)) * 12 ;
			$time['end']['diff'] += ( 12-date('m', $min_year)+1 ) - (12-$month_e) ;

			$start_date = $time['start']['diff'];
			$end_date = $time['end']['diff'];

			if ($day_total_s != '' && $day_total_s != 0) {
				$start_date += (int)$day_s/$day_total_s;
			}

			if ($day_total_e != '' && $day_total_e != 0) {
				$end_date += (int)$day_e/$day_total_e;
			}

			$unit = $time['object'];

			$startdate = osa_date_format($unit->startdate);
			$enddate = osa_date_format($unit->enddate);

			// (issue: 89) Make the first day of the month fall on the month line for the graph
			if ( $start_date - (int) $start_date < 0.04 ) {
				$start_date = (int) $start_date;
			}

			$val = new hbar_value( $start_date , $end_date );
			$newtext = wordwrap($unit->title, 30, "\n", true);
			$newtext = htmlspecialchars_decode($newtext);
			$val->set_tooltip($newtext.'<br />'.lang('unit_calendar_startdate').': ' .$startdate.' --> '.lang('unit_calendar_enddate').': '.$enddate );
			$url = base_url() . "unit/unit/read_unit_calendar/".$unit->unitid;
			// (issue: 141) must specific parent div id
			$on_click = "showChartUnitlist('$url','Unit Calendar',900,800,'unitread','unit_calendar')";
			$val->on_click($on_click);
			$hbar->append_value($val);

			$y_labels[] = $newtext;

		}

		$y_labels = array_reverse($y_labels);
 		$max_loop  = ( date('Y', $max_year) -  date('Y', $min_year)) * 12 ;
 		$max_loop += ( 12-date('m', $min_year)+1 ) - (12-date('m', $max_year)) ;
 		$max_loop += 1; // begin at 0 and end at next last month

 		//x_axis
 		//$months = array(1=>'Jan',2=>'Feb',3=>'Mar',4=>'Apr',5=>'May',6=>'Jun',7=>'Jul',8=>'Aug',9=>'Sep',10=>'Oct',11=>'Nov',12=>'Dec',);
 		$months = array(1=>lang('gen_cal_jan'), 2=>lang('gen_cal_feb'), 3=>lang('gen_cal_mar'),
 							 4=>lang('gen_cal_apr'), 5=>lang('gen_cal_may'), 6=>lang('gen_cal_jun'),
 							 7=>lang('gen_cal_jul'), 8=>lang('gen_cal_aug'), 9=>lang('gen_cal_sep'),
 							 10=>lang('gen_cal_oct'), 11=>lang('gen_cal_nov') ,12=>lang('gen_cal_dec'));
		$x_labels = array();

		if ( (int)date('m', $min_year) == 1 ) {
			// (issue: 89) Month in graph gets shifted right when the minimum date falls on Janurary
			$last_year = (int)date('y', $min_year) - 1;
	 		$last_month = 12;
		}
		else {
			$last_year = (int)date('y', $min_year);
	 		$last_month = (int)date('m', $min_year) - 1;
		}
 		for ($i=0;$i<=$max_loop;$i++) {
 			if ($last_month > 12) {
 				$last_month = 1;
 				$last_year += 1;
 			}
 			if ((int)$last_year < 10)
 				$format_year = '0' . $last_year;
 			else
 				$format_year = $last_year;
 			if (array_key_exists($last_month,$months))
	 			$x_labels[] = $months[$last_month].$format_year ;

 			$last_month += 1;
 		}

		$x = new x_axis();
		$x->set_offset( false );

		$x_lbl = new x_axis_labels();
		$x_lbl->set_vertical();
		$x_lbl->set_labels( $x_labels );
		// Add the X Axis Labels to the X Axis
		if (count($x_labels) <= 12){
			$x->set_labels_from_array($x_labels);
		}
		else{
			$x->set_labels( $x_lbl );
		}

		$chart->set_x_axis( $x );



		//y_axis
		$y = new y_axis();
		$y->set_offset( true );
		$y->set_labels($y_labels);
		$chart->add_y_axis( $y );
		$chart->add_element( $hbar );

		//Set Tooltip
		$tooltip = new tooltip();
		$tooltip->set_hover();
		$tooltip->set_stroke( 1 );
		$tooltip->set_colour( "#000000" );
		$tooltip->set_background_colour( "#FFF8DC" );
		$chart->set_tooltip( $tooltip );

		$result = $chart->toPrettyString();

		//echo $result;
		if (count($data) > 0 ){
			$this->CI->session->set_userdata('fc_' . $data->divid, $result);
		}
		else{
			$this->CI->session->set_userdata('fc_' . $data->divid, '{}');
		}

		return $result; //Return value not used becuase the chart controller gets the data from the session

	}
	function check_date($month,$year) {
		$day = '';
		if ( checkdate($month, 31, $year) )
			$day = 31;
		elseif (checkdate($month, 30, $year))
			$day = 30;
		elseif (checkdate($month, 29, $year))
			$day = 29;
		else
			$day = 28;
		return $day;
	}


}

?>