<?php
/**
 * driver_base.php - The batch drive base class
 *
 * @author $Author: dtong $
 * @version $Id: driver_base.php,v 1.3 2009/08/17 03:25:38 dtong Exp $
 * @copyright Copyright (c) 2009, Tiller Software Co., Ltd.
*/
require_once('config_main.php');

if ( ! defined('BASEPATH')) exit('No direct script access allowed');

abstract class batch_driver_base {

	protected $config=NULL;
	protected $config_main=NULL;
	protected $CI = NULL;

	function __construct($config) {
		$this->config = $config;
		$this->CI = & get_instance();
		$this->config_main = new cms_batch_main_config;
	}

	abstract protected function get_courses();
	abstract protected function get_users();
	abstract protected function get_course_grade();
	abstract protected function get_user_course();

	public function get_config() {
		return $this->config;
	}

	public function config_value($name) {
		if ( isset($this->config->$name) ) {
			return $this->config->$name;
		}

		if ( isset($this->config_main->$name) ) {
			return $this->config_main->$name;
		}

		return NULL;
	}
}
?>