<?php
/**
 * batch_factory.php - Factory class for getting the proper config file and
 * 	providing the proper driver to the main batch object. The return result is
 * 	the main batch object
 *
 * @author $Author: dtong $
 * @version $Id: batch_factory.php,v 1.1 2009/08/13 10:08:02 dtong Exp $
 * @copyright Copyright (c) 2009, Tiller Software Co., Ltd.
*/
require_once ('batch_main.php');

class Batch_factory {

   public static function factory($config='') {
   	if ( $config == '' ) {
   		$CI =& get_instance();
   		$config = $CI->config->item('cms_batch_config');
   	}
   	if ( include_once 'config/' . $config . '.php') {
			$configobj = new cms_batch_config;
			$driver = $configobj->db_driver;
			if ( include_once 'driver/' . $driver . '.php' ) {
				$driverobj = new cms_batch_driver($configobj);
				$mainobj = new batch_main($driverobj);
				return $mainobj;
			}
		}
			return FALSE;
   }
}
?>