<?php
/**
 * admin_base.php - The main library for interfacing various components for admin_base
 *
 * @author $Author: dtong $
 * @version $Id: admin_base.php,v 1.37 2011/04/27 05:46:27 dtong Exp $
 * @copyright Copyright (c) 2009, Tiller Software Co., Ltd.
*/

Class Admin_base {
	private $CI;
	private $config=NULL;
	private $page_type_config = array(
		CMS_ADMIN_USER_TYPE => 'admin/user',
		CMS_ADMIN_COURSE_TYPE => 'admin/course',
		CMS_ADMIN_DEPARTMENT_TYPE => 'admin/department',
		CMS_ADMIN_STRAND_TYPE => 'admin/strand',
		CMS_ADMIN_STANDARD_TYPE => 'admin/standard',
		CMS_ADMIN_BENCHMARK_TYPE => 'admin/benchmark',
		CMS_ADMIN_EQ_TYPE => 'admin/eq',
	);

	function __construct() {
		$this->CI = get_instance();
	}

	//function getpage menutree
	function getpage($type=FALSE) {
		if ($type == FALSE)
			return FALSE;
		if ( array_key_exists($type, $this->page_type_config) ) {
			return $this->page_type_config[$type];
		}
		return FALSE;
		/*
		switch ($type) {
	        case CMS_ADMIN_USER_TYPE:
	        	 return 'admin/user';
	             break;
	        case CMS_ADMIN_COURSE_TYPE:
	             return 'admin/course';
	       		 break;
	        case CMS_ADMIN_DEPARTMENT_TYPE:
	        	 return 'admin/department';
	        	 break;
	        case CMS_ADMIN_STRAND_TYPE:
	       		 return 'admin/strand';
	             break;
	        case CMS_ADMIN_STANDARD_TYPE:
	             return 'admin/standard';
	       		 break;
	        case CMS_ADMIN_BENCHMARK_TYPE:
	        	 return 'admin/benchmark';
	        	 break;
	        case CMS_ADMIN_EQ_TYPE:
	        	 return 'admin/eq';
	        	 break;
		 } */
	}

	//This function prvides strings for the filer selections.
	//Add new language strings or just use the generic ones
	function getlistitem($div) {
		$list=array();
		if ( $div == 'goal' ) {
			$list[CMS_ADMIN_ALL]   	 = lang('goal_filter_all');
			$list[CMS_ADMIN_ENABLE]  = lang('goal_filter_enabled');
			$list[CMS_ADMIN_DISABLE] = lang('goal_filter_disabled');
		}
		else {
			//Make sure to add new language strings according the format here
			$all = lang("admin_{$div}_all");
			$enable = lang("admin_{$div}_enabled");
			$disable = lang("admin_{$div}_disabled");
			if ( empty($all) || empty($enable) || empty($disable) ) {
				$all = lang("admin_generic_items_all");
				$enable = lang("admin_generic_items_enabled");
				$disable = lang("admin_generic_items_disabled");
			}
			$list[CMS_ADMIN_ALL] = $all;
			$list[CMS_ADMIN_ENABLE]  = $enable;
			$list[CMS_ADMIN_DISABLE] = $disable;
		}
		/*
		switch ($div) {
  			case "user":
		       	$list[CMS_ADMIN_ALL]   	 = lang('admin_user_all');
				$list[CMS_ADMIN_ENABLE]  = lang('admin_user_enabled');
				$list[CMS_ADMIN_DISABLE] = lang('admin_user_disabled');
             	break;
         case "course":
		      	$list[CMS_ADMIN_ALL]   	 = lang('admin_course_all');
				$list[CMS_ADMIN_ENABLE]  = lang('admin_course_enabled');
				$list[CMS_ADMIN_DISABLE] = lang('admin_course_disabled');
             	break;
         case "department":
		    	$list[CMS_ADMIN_ALL]   	 = lang('admin_department_all');
				$list[CMS_ADMIN_ENABLE]  = lang('admin_department_enabled');
				$list[CMS_ADMIN_DISABLE] = lang('admin_department_disabled');
             	break;
             case "strand":
		    	$list[CMS_ADMIN_ALL]   	 = lang('admin_strand_all');
				$list[CMS_ADMIN_ENABLE]  = lang('admin_strand_enabled');
				$list[CMS_ADMIN_DISABLE] = lang('admin_strand_disabled');
             	break;
         case "standard":
		    	$list[CMS_ADMIN_ALL]   	 = lang('admin_standard_all');
				$list[CMS_ADMIN_ENABLE]  = lang('admin_standard_enabled');
				$list[CMS_ADMIN_DISABLE] = lang('admin_standard_disabled');
             	break;
         case "benchmark":
		    	$list[CMS_ADMIN_ALL]   	 = lang('admin_benchmark_all');
				$list[CMS_ADMIN_ENABLE]  = lang('admin_benchmark_enabled');
				$list[CMS_ADMIN_DISABLE] = lang('admin_benchmark_disabled');
             	break;
         case "goal":
		    	$list[CMS_ADMIN_ALL]   	 = lang('goal_filter_all');
				$list[CMS_ADMIN_ENABLE]  = lang('goal_filter_enabled');
				$list[CMS_ADMIN_DISABLE] = lang('goal_filter_disabled');
             	break;
			}
		*/
		return $list;
	}
/*
	//function dropdown gettype
	function gettype() {
		$type=array();
		$type[0] 						 = lang('admin_type_ddldefualt');
		$type[ENDURING_RES_TYPE] 		 = 'ENDURING_RES_TYPE';
		$type[ASSESSMENT_TYPE] 			 = 'ASSESSMENT_TYPE';
		$type[ASSESSMENT_UPLOAD_TYPE] 	 = 'ASSESSMENT_UPLOAD_TYPE';
		$type[LEARNING_TYPE] 			 = 'LEARNING_TYPE';
		$type[LEARNING_UPLOAD_TYPE] 	 = 'LEARNING_UPLOAD_TYPE';
		$type[ESSENTIAL_QUESTION_TYPE] 	 = 'ESSENTIAL_QUESTION_TYPE';
		$type[ITSTANDARDS_TYPE] 		 = 'ITSTANDARDS_TYPE';
		$type[TEACHER_EQ_TYPE] 			 = 'TEACHER_EQ_TYPE';
		$type[LEARNING_TARGETS_TYPE] 	 = 'LEARNING_TARGETS_TYPE';
		$type[ITSTANDARDS_RESOURCE_TYPE] = 'ITSTANDARDS_RESOURCE_TYPE';
		$type[OUTCOMES_SKILLS_TYPE] 	 = 'OUTCOMES_SKILLS_TYPE';

		return $type;
	}
*/
	//function create menu_tree admin
	function getmenu() {
		require_once('adminmenu_factory.php');
		return adminmenu_factory::factory();
	}
	function link_getpage($url, $title, $width, $height, $div,$display,$linktitle) {
		$href = '"'.base_url() . $url.'"';
		$result =  "<a onclick=' ajaxGetpage($div, $href,false); ";
		$result .=  "return false;' href=$href class='cmslink' title=\"$linktitle\">{$display}</a>";

		return $result;
	}
	function new_getpage($url, $title, $width, $height, $div, $imgname, $imgtitle) {
		$href     = '"'.base_url() . $url.'"';
		$result   =  "<a onclick='ajaxGetpage($div, $href,false); ";
		$result  .=  "return false;' href=$href ><img src=\"$imgname\" title=\"$imgtitle\" border='0' /></a>";

		return $result;
	}
	function linkDhtmlWindow($url, $title, $width, $height, $div,$display,$linktitle) {
		$href = '"'.base_url() . $url.'"';
		$result =  "<a onclick='newDhtmlWindow($href, \"$title\", $width, $height, \"$div\"); ";
		$result .=  "return false;' href=$href class='cmslink' title=\"$linktitle\">{$display}</a>";

		return $result;
	}
	function newDhtmlWindow($url, $title, $width, $height, $div, $imgname, $imgtitle) {
		$href     = '"'.base_url() . $url.'"';
		$result   =  "<a onclick='newDhtmlWindow($href, \"$title\", $width, $height, \"$div\"); ";
		$result  .=  "return false;' href=$href ><img src=\"$imgname\" title=\"$imgtitle\" border='0' /></a>";

		return $result;
	}
    function delTarget($url, $page, $massage, $imgname, $imgtitle,$formname=FALSE) {
	    $href   = '"'.base_url() . $url.'"';
		$result   =  "<a onclick='del_listitem($href, \"$page\",\"$massage\",\"$formname\"); ";
		$result  .=  "return false;' href=$href  ><img src=\"$imgname\" title=\"$imgtitle\" border='0' /></a>";

		return $result;
	}

	//function init_displaylist
	function init_display($admintype, $listflag, $divid) {
		//TODO: Old programmers used a lot of PHP session which we don't want.
		//Have to clean this up later. Uncomment the following and all the admin features will break...
		//osa_php_session_destroy();
		$display = new display_list();
   	$display->page = $this->getpage($admintype);
   	$display->selectlistitem = $listflag;
   	$display->listitem = $this->getlistItem($divid);
		$display->default_img = 0;
		$display->default_col = 0;
		$display->divid = $divid ;
		$display->searchid = $divid;
		$display->type = '';
		$display->menu = '';
		$display->strand = array();
		$display->data_dep_sch = array();
		$display->standard = array();
		$display->filter = '';
   	return $display;
	}

	// highlight text search
 	function highlight($splits, $string) {
		$highlight = $string;
		foreach ($splits as $str) {
			//$highlight = str_ireplace( trim($str), '<font color="red"><b>'.trim($str).'</b></font>', $highlight )  ;
			$highlight = @preg_replace("/($str)/i", '<font color="red"><b>\1</b></font>', $highlight);
		}
		return $highlight;
	}
	// split text search
  function split($string) {
		if (!isset($string))
			return FALSE;

		$split = FALSE;
		$split = explode(' ',$string);
		$result   = array();

		if ( !is_array($split) )
			return FALSE;

		foreach ($split as $str)
			if ( $str != '' &&  $str != ' ')
				$result[] = $str;

		return $result;
	}

	//Loads the admin_list_view, usually called at the end of the admin controller
	function load_view(&$display, $data = FALSE) {
		$display->iswindow = FALSE;
		$display->force_sort = TRUE;
      $display->prepare_page();
      if ( $data === FALSE || !is_object($data) ) {
      	$data = new stdClass();
      }
      $data->display = $display;
      echo $this->CI->load->view('tablelist/admin_list_view', $data, TRUE);
      //$display->save_session();
	}

}
?>