<?php
/**
 * select.php - Controller for Builder/Template Selection, uses DHTML window instead of iFrame
 *
 * @author $Author: dtong $
 * @version $Id: select.php,v 1.18 2011/05/09 04:48:52 dtong Exp $
 * @copyright Copyright (c) 2009, Tiller Software Co., Ltd.
*/

class Select extends CI_Controller {
//private $unitcontroller=NULL;

	function __construct() {
		parent::__construct();
		$this->load->model('unit/unit_model');
		$this->load->model('unit/select_model');
		//$this->load->model('unit/resource_model');
		osa_load_lang('unit');
		osa_load_lang('general');
		$this->load->helper('form');
		if ( !$this->access_model->checkaccess_any('unit_read', FALSE, FALSE, FALSE) ) {
			//A view won't print to the client until this returns and an exist
			//would result in no output. So, just echo it here. Noticed the 3rd parameter in the load->view
			echo $this->load->view('unit/unit_htmlerror_view', array('errormsg'=>lang('unit_no_permissionmsg')),TRUE);
			exit;
		}
	}

	/*
	 * This is the inital loading of the window. Ajax is done using DHTML window
	 * so we can't use out ajax error rotocol
	 */
	function add($unitid, $type) {
		if ( !is_numeric($unitid) || !is_numeric($type) ) {
			$this->load->view('template/ajax_error_view',
				array('errormsg' => lang('unit_no_permissionmsg'), 'divid' => 'select'));
			return;
		}
		//Only editors can run this, exits if false
		if ( ($unit = $this->unit_model->check_unit_editaccess($unitid)) === FALSE) {
			$this->load->view('template/ajax_error_view',
				array('errormsg' => lang('gen_internalservererror'), 'divid' => 'select'));
			return;
		}

		$this->load->library('unit/unitmain',
			array('action'=>CMS_ACTION_ADD,'unitid'=>$unitid, 'courseid'=>$unit->courseid));

		$selectobj = $this->unitmain->get_select_obj($type, $unitid);
		if ( $selectobj->template_data() == FALSE ) {
			osa_errorlog(__METHOD__ . " - Failed to get template type:$type unit:$unitid.");
			$this->load->view('template/ajax_error_view',
				array('errormsg' => lang('gen_internalservererror'), 'divid' => 'select'));
			return;
		}

		if ( ($dept_obj = $this->unit_model->get_departbyparent($unitid, true, 'deptid')) === FALSE ) {
		//if ( ($dept_obj = $this->select_model->getdept($unit->courseid)) === FALSE ) {
			osa_errorlog(__METHOD__ . ' - Failed to get department.', $unit);
			$this->load->view('template/ajax_error_view',
				array('errormsg' => lang('gen_internalservererror'), 'divid' => $selectobj->getval('_divid')));
			return;
		}
		$title = '';
		$deptids = array();
		$comma = '';
		if ($dept_obj != FALSE)
			foreach ($dept_obj as $obj) {
				$deptids[] = $obj->deptid;
				$title .= $comma . $obj->name;
				$comma = ', ';
			}

		//department id is set to 0 for system wide selects
		if ( $selectobj->getval('_no_dept_flag') === TRUE )
			$deptids = 0;

		if ( ($sel_dbobjs = $this->select_model->get($unitid, $deptids, $type, $selectobj->getval('_cattext_flag2'))) === FALSE ) {
			osa_errorlog(__METHOD__ . " - Failed to get selections type:$type.", $dept_obj);
			$this->load->view('template/ajax_error_view',
				array('errormsg' => $selectobj->getval('_nodata_text'),
					'divid' => $selectobj->getval('_divid')));
			return;
		}

		$params = $selectobj->get_params();
		$data->deptobj = $dept_obj;
		$data->selobj = $sel_dbobjs;
		$data->template = $selectobj;
		$data->unitid = $unitid;
		$data->type = $type;
		$data->stagenum = $params->stagenum;
		$data->divid = $params->divid;
		$data->depdisplay = false;
		//check if multi-course and multi-department then show department_display
		if ( ($parents = $this->unit_model->get_unit_byparentid($unitid, 'c.id')) !== FALSE) {
			$courseid = false;
			foreach ($parents as $row)
				$courseid[] = $row->courseid;
			$data->depdisplay = $this->unit_model->show_department_display($courseid);
			if ($data->depdisplay !== false)
				$data->depdisplay = true;
		}

		if ( ($subtitle = $selectobj->getval('_subtitle')) !== FALSE )
			$subtitle = str_replace('_AREA_NAME_', $title, $subtitle);
		else
			$subtitle = FALSE;
		$data->subtitle = $subtitle;
		$this->load->view('unit/unit_seladd_view', $data);
	}

	function update($unitid, $type) {
		if ( !is_numeric($unitid) || !is_numeric($type) ) {
			echo osa_ajaxmsg(lang('gen_internalservererror'));
			exit;
		}
		//Only editors can run this, exits if false
		if ( ($unit = $this->unit_model->check_unit_editaccess($unitid)) === FALSE ) {
			echo osa_ajaxmsg(lang('unit_no_permissionmsg'));
			exit;
		}
		$keys = array_keys($_POST);
		$pattern = 'catid';
		$ids = array();
		$sep = '';
		foreach($keys as $key) {
			$tok = strtok($key,'_');
			if ($tok==$pattern) {
				$formid = strtok('_');
				if ( is_numeric($formid)) {
					//$ids .= $sep . $formid;
					//$sep=',';
					if ( is_numeric($_POST[$key]) )
						$ids[$formid] = $formid;
				}
			}
		}
		if ( ($this->select_model->update($unitid, $type, $ids)) === FALSE ) {
			echo osa_ajaxmsg(lang('unit_failedtoadddata'));
			exit;
		}
		echo 'success';
		exit;
	}

	function delete($unitid, $selid) {
		$this->unit_model->check_unit_editaccess($unitid);
		if ( !$this->select_model->delete($unitid,$selid) ) {
			echo osa_ajaxmsg(lang('unit_failedtodeletedata'));
      	exit;
		}
	}
}
?>