<?php
/**
 * lt.php - Learning Targets controll file
 *
 * @author $Author: dtong $
 * @version $Id: lt.php,v 1.18 2011/05/09 04:48:52 dtong Exp $
 * @copyright Copyright (c) 2009, Tiller Software Co., Ltd.
*/

class lt extends CI_Controller {
//private $unitcontroller=NULL;

	function __construct() {
		parent::__construct();
		//$this->load->helper('form');
		$this->load->model('unit/unit_model');
		$this->load->model('unit/lt_model');
		osa_load_lang('unit');
		if ( !$this->access_model->checkaccess_any('unit_read', FALSE, FALSE, FALSE) ) {
			//A view won't print to the client until this returns and an exist
			//would result in no output. So, just echo it here. Noticed the 3rd parameter in the load->view
			echo $this->load->view('unit/unit_htmlerror_view', array('errormsg'=>lang('unit_no_permissionmsg')),TRUE);
			exit;
		}
	}

	function add($unitid, $type) {
		if ( !is_numeric($unitid) || !is_numeric($type) ) {
			$this->load->view('template/ajax_error_view',
				array('errormsg' => lang('unit_no_permissionmsg'), 'divid' => 'learningtarget'));
			return;
		}
		//Only editors can run this, exits if false
		if ( ($unit = $this->unit_model->check_unit_editaccess($unitid)) === FALSE) {
			$this->load->view('template/ajax_error_view',
				array('errormsg' => lang('gen_internalservererror'), 'divid' => 'learningtarget'));
			return;
		}

		//Get the lt template object
		$this->load->library('unit/unitmain',
			array('action'=>CMS_ACTION_ADD,'unitid'=>$unitid, 'courseid'=>$unit->courseid));
		$ltobj = $this->unitmain->get_lt_obj($type, $unitid);
		if ( !$ltobj || $ltobj->template_data() == FALSE ) {
			osa_errorlog(__METHOD__ . " - Failed to get template type:$type unit:$unitid.");
			$this->load->view('template/ajax_error_view',
				array('errormsg' => lang('gen_internalservererror'), 'divid' => 'learningtarget'));
			return;
		}
		//$sort_type = osa_template_sort_type($ltobj->template_data());
		//Get the sort type from the lt edit template which different than the non-edit template
		$sort_type = osa_template_sort_type($this->unitmain->get_lt_edittemplate());
		$data = new stdClass();
		$data->sort_type = $sort_type;
		$this->lt_model->sort_type = $sort_type;
		$this->lt_model->sort_filehash = $this->unitmain->get_template_filepart();
		//Get the selections from the DB and type TYPE_NORMAL
		//if ( $unit->type != $this->unit_model->TYPE_INT_PARENT && $unit->type != $this->unit_model->TYPE_UNI_PARENT ) {
		//	$ltdbobj = $this->lt_model->get_selections($unit->courseid,$type);
		//}
		//Get the selections from the DB And type (TYPE_INT_PARENT,TYPE_UNI_PARENT)
		//if ( $unit->type == $this->unit_model->TYPE_INT_PARENT || $unit->type == $this->unit_model->TYPE_UNI_PARENT ) {
		if ( ($dept_obj = $this->unit_model->get_departbyparent($unitid)) === FALSE ) {
			osa_errorlog(__METHOD__ . ' - Failed to get department.', $unit);
		}
		$course_items = array();
		if ($dept_obj != FALSE) {
			foreach ($dept_obj as $obj) {
				if (!in_array($obj->courseid, $course_items))
				$course_items[] = $obj->courseid;
			}
		}
		$ltdbobj = $this->lt_model->get_selections($unit->courseid, $type, $course_items);

			/*
			//i'm not sure
			$isedit = FALSE;
			//Check edit access, exists if false
			if ( $isedit ) {
				$this->_checkEditAccess($courseid);
				$lt_only_flag = FALSE;
			} else {
				$lt_only_flag = TRUE;
			}

			$publish = FALSE;
			$publish = $this->unit_model->get_publish_units_bygroup($unit);
			if (!$publish)
				$publish_id = $unitid;	// nothing for else
			else
				$publish_id = $publish->id;
			$childs = $this->unit_model->get_childs_unit($publish_id);

			//Let's loop thru the course_lt_link
			$course_items = array();
			if ( is_array ($childs) ){
				foreach ($childs as $child) {
					$course_items[].=$child->courseid;
				}
			}
			$ltdbobj = $this->lt_model->get_selections($unit->courseid,$type,$course_items);
			*/
		//}

		$data->db = $ltdbobj;
		$data->template = $ltobj;

		$last_standard = '';
		$last_bench = '';
		$db_struct = array();
		//Old ZMS uses multiple queries to do this, but we just use one query
		//It is a lot more code but it is 10 times faster!
		//$depts = $this->lt_model->get_departments_bycourse('id', TRUE);
		//fix get department name by course_sis.department_display.
		//TODO: This gets all the dpeartments and courses which is not necessary
		$depts = $this->unit_model->get_department_display(false, 'courseid', TRUE);
		$depts_name    = array();
		$last_deptname = '';
		$selectedids = FALSE;
		if ( $ltdbobj ) {
			foreach($ltdbobj as $record) {
				if ( $last_standard != $record->standardid) {
					if ( $this->config->item('cms_lt_importid_support') ) {
						$db_struct[$record->standardid][0] = "{$record->standard_importid} {$record->standard}";
					}
					else {
						$db_struct[$record->standardid][0] = $record->standard;
					}
					$last_standard = $record->standardid;
				}
				if ($last_bench != $record->benchmarkid) {
					//$benchmark[$record->standardid][0][0] = $record->benchmarkid;
					if ( $this->config->item('cms_lt_importid_support') ) {
						$db_struct[$record->standardid][$record->benchmarkid][0] = "{$record->benchmark_importid} {$record->benchmark}";
					}
					else {
						$db_struct[$record->standardid][$record->benchmarkid][0] = $record->benchmark;
					}
					$last_bench = $record->benchmarkid;
				}

				$db_struct[$record->standardid][$record->benchmarkid][] = $record;

				if ( array_key_exists($record->courseid, $depts) ) {
					$deptname = $depts[$record->courseid]->name;
					if ($last_deptname =='' || $last_deptname!= $deptname) {
						$record->deptname = $deptname;
						$last_deptname = $deptname;
					  	$depts_name[$record->standardid] = $record;
					}
				}
			}
			$selectedids = $this->lt_model->get_unit_targets($unitid, $type);
		}

		if ( !$selectedids )
			$selectedids = array();
		else {
			$ids = array();
			foreach($selectedids as $unit_target) {
				$ids[] = $unit_target->targetid;
			}
			$selectedids = $ids;
		}
		$data->selectedids = $selectedids;
		$data->db_struct   = $db_struct;
		$data->depts_name  = $depts_name;
		$data->courseid = $unit->courseid;
		$this->load->view('unit/unit_ltadd_view', $data);
	}

	function update ($unitid, $type) {
		if ( !is_numeric($unitid) || !is_numeric($type) ) {
			$this->load->view('template/ajax_error_view',
				array('errormsg' => lang('unit_no_permissionmsg'), 'divid' => 'learningtarget'));
			return;
		}
		//Only editors can run this, exits if false
		if ( ($unit = $this->unit_model->check_unit_editaccess($unitid)) === FALSE) {
			$this->load->view('template/ajax_error_view',
				array('errormsg' => lang('gen_internalservererror'), 'divid' => 'learningtarget'));
			return;
		}

		$keys = array_keys($_POST);
		$pattern = 'lt';
		$ids = array();
		$sep = '';
		foreach($keys as $key) {
			$tok = strtok($key,'_');
			if ($tok==$pattern) {
				$formid = strtok('_');
				if ( is_numeric($formid)) {
					//$ids .= $sep . $formid;
					//$sep=',';
					if ( is_numeric($_POST[$key]) )
						$ids[$formid] = $_POST[$key];
				}
			}
		}

		if ( ($this->lt_model->update($unitid, $type, $ids)) === FALSE ) {
			echo osa_ajaxmsg(lang('unit_failedtoadddata'));
			exit;
		}
		echo 'success';
		exit;
	}

	function delete ($unitid, $targetid) {
		$this->unit_model->check_unit_editaccess($unitid);
		if ( !$this->lt_model->delete($unitid,$targetid) ) {
			echo osa_ajaxmsg(lang('unit_failedtodeletedata'));
      	exit;
		}
	}
}

