<?php
/**
 * html_data.php - Controller for standard html data submit support. Right now, only radio button is supported.
 * 					 This can be easily modified to support dropdowns and checkboxes.
 *
 * @author $Author: dtong $
 * @version $Id: html_data.php,v 1.2 2011/02/11 09:09:25 dtong Exp $
 * @copyright Copyright (c) 2010, Tiller Software Co., Ltd.
*/
class html_data extends CI_Controller{

	function __construct() {
		parent::__construct();
		$this->load->model('auth/survey_login_model');
		$this->load->model('survey/survey_model');
		$this->load->model('unit/html_data_model');
	}

	//Function to add or change survey data in the table template_htmldata.
	function add($extid, $type, $radio_select, $question_index=FALSE, $weight=FALSE){
		if ( !$this->_check_access($extid, $type) ) {
			echo 'failed';
			return;
		}
 		if ( $this->html_data_model->add($extid,$type,$radio_select,$question_index,$weight) ) {
 			echo 'success';
 			return;
 		}
 		$tmp = array($extid, $type, $radio_select, $question_index, $weight);
 		osa_errorlog(__METHOD__ . ' - Failed to update radio input.', $tmp);
 		echo 'failed';
 		return;
	}

	//Checks access to make sure the user has write access for the supplied data
	private function _check_access($extid, $type) {
		$this->load->library('cms/cms_template/cms_template');
		$template_type = $this->cms_template->type_templateid($type);

		//Only checks for survey for now
		//Got to think of a better way to check access for other template types
		switch ($template_type) {
			case CMS_TEMPLATE_SURVEY_IDENTIFIER:
				$user = $this->survey_login_model->getLogin();
				if ( !$user || $user->resultid != $extid ) {
					return FALSE;
				}
				break;
		}
		return TRUE;
	}
}