<?php
/**
 * compare.php - Unit controller
 *
 * @author $Author: dtong $
 * @version $Id: compare.php,v 1.26 2011/05/11 05:34:32 dtong Exp $
 * @copyright Copyright (c) 2009, Tiller Software Co., Ltd.
*/
require_once(APPPATH . 'libraries/mapping/display_list.php');
class Compare extends CI_Controller{
	function __construct() {
		parent::__construct();
		$this->access_model->checkaccess_any('unit_read');
		$this->load->helper('form');
		$this->load->helper('date');
		osa_load_lang('unit');
		osa_load_lang('general');
		$this->load->library('form_validation');
		$this->load->library('unit/unit_init');
		$this->load->library('unit/compare/unit_compare');
		$this->load->model('unit/unit_model');
		$this->load->model('sort/searchsort_model');
	}

	function current($unitid=FALSE) {
		if (!isset($unitid) || !is_numeric($unitid) ) {
			echo lang('unit_no_permissionmsg');
			return FALSE;
		}

		$unit = $this->unit_model->get_unit_any($unitid);
		$current = $this->unit_model->get_last_version($unit);

		if (!isset($current) || !isset($current->id) || !is_numeric($current->id) ) {
			echo lang('unit_no_permissionmsg');
			return FALSE;
		}

		$this->version($unitid, $current->id);

		return FALSE;
	}

   function history($unitid, $isParent=FALSE) {
   	$display = new display_list();
   	if ($isParent !==FALSE)
   		 $display->formname = 'unit_parent_history_form';
   	else
   		 $display->formname = 'unit_history_form';

		$display->image_sort = 1;
		$display->default_col = 0;
		$display->divid = $display->formname ;
		$display->searchid = $display->formname ;
		$display->titles = array(lang('unit_history_col_revision'),
										 lang('unit_history_col_revisiontime'),
										 lang('unit_history_col_select')
								 );
		$display->widths = array('40%', '50%', '10%');

		$data_group = $this->unit_model->get_unit_any($unitid);
		$data  = $this->unit_model->get_unit_history($data_group,TRUE);

		$display->unit = $this->unit_model->get_parentinfo($unitid);
		//$display->unit->unit = $this->unit_model->get_unit($unitid);
		if (isset($data) &&  $data !== FALSE) {
			foreach ($data as $key => $rows) {
				if (isset($rows) && $rows != FALSE)
				{
					$unitid = $rows->id;//$rows->id;
					$checked = '';
					$version = $rows->version;
					$modifydate = osa_date_format($rows->modifydate);
					if ($rows->version < 10)
						$version = '0'.$rows->version;

					if ($rows->version == null || $rows->version == '') {
						$css = '';
						if (isset($rows->status) && $rows->status ==  CMS_UNIT_STATUS_PUBLISH) {
							$css = 'class="unit_history_current"';
							$version = lang('unit_history_current');
						}
						else if (isset($rows->status) && $rows->status == CMS_UNIT_STATUS_EDIT) {
							$css = 'class="unit_history_editting"';
							$version = lang('unit_history_editting');
						}

						$version = '<span '.$css.'>'. $version . '</span>';
						$modifydate = '<span '.$css.'>'.$modifydate. '</span>';
					}
					else {
						$version = $version;
						$modifydate = $modifydate;
					}
					$checked = form_checkbox('unitid[]', $unitid, FALSE, '');

					$temp = array($version, "$modifydate", $checked);
					$display->add($temp);
				}
			}
		}
		$display->column_data_align[0] = 'center';
		$display->column_data_align[1] = 'center';
		$display->column_data_align[2] = 'center';
		$display->allpage = TRUE;
	  	$display->iswindow = FALSE;
		$display->force_sort = TRUE;
		$display->default_col = 1;
		$display->sort_direction = display_list::SORT_DESC;
      $display->prepare_page();
      $data = new stdClass();
      $data->display = $display;
      $CI = & get_instance();
      echo $CI->load->view('tablelist/unithistory_list_view', $data, TRUE);
      //$display->save_session();
    }

    //Compare Version
	function version($unitid_left=FALSE, $unitid_right=FALSE, $use_combo=TRUE) {
		if (isset($_POST['unitid']) && is_array($_POST['unitid'])) {
			$units = $_POST['unitid'];

			$error = FALSE;
			foreach ($units as $row) {
				if ($row != null && $row != '') {
					if ($unitid_left===FALSE) {
						$unitid_left = $row;
					} elseif ($unitid_right===FALSE) {
						$unitid_right = $row;
					} else {
						$error = $row;
					}
				}
			}
			if ($error != FALSE || $unitid_left===FALSE || $unitid_right===FALSE){
				echo osa_ajaxmsg(lang('unit_history_massage_req'));
 				return FALSE;
			}
			//for unit compare
			echo  $unitid_left . '/' . $unitid_right;

			return FALSE;
		} else {
			if (isset($_POST['unitid']) && isset($_POST['unitid'])) {
				$unitid_left  = $_POST['unitid_left'];
				$unitid_right = $_POST['unitid_right'];
				$use_combo = FALSE;
			} else {
				if($unitid_left===FALSE || $unitid_right===FALSE || !is_numeric($unitid_left) || !is_numeric($unitid_right)){
					echo osa_ajaxmsg(lang('unit_history_massage_req'));
		 			return FALSE;
				}
			}
		}

		$data_left  = $this->_load_compare_render($unitid_left, CMS_UNIT_COMPARE_LEFT);
		$data_right = $this->_load_compare_render($unitid_right);

		$data = $data_left;

		//Get group
		$data_group = $this->unit_model->get_unit_any($unitid_left);

		//dropdown history
		//$data_history  = $this->unit_model->get_unit_history($data_group->groupid);
		$data->history = $this->unit_model->get_unit_history($data_group);
		$data->history_left  = $unitid_left;
		$data->history_right = $unitid_right;

 		$data->unit_left   = $data_left->unit;
 		$data->unit_right  = $data_right->unit;

 		$data->unit_left->typename   = $data_left->unittypename;
 		$data->unit_right->typename  = $data_right->unittypename;

 		$data->unit_left->unitbody   = $data_left->unitbody;
 		$data->unit_right->unitbody  = $data_right->unitbody;

 		$data->css_title = $this->unit_compare->highlight_title($data_left , $data_right);

 		$data->html = $this->unit_compare->highlight($data_left , $data_right);
		$data->use_combo = $use_combo;

		$data->multi_scroll = $this->config->item('cms_unitcompare_multi_scroll');
		$this->load->view('unit/unit_compare_view', $data);
	}

	//render to unitbody(html)
	private function _load_compare_render($unitid, $compare_flag=FALSE) {
		$data = $this->unit_init->get_viewdata($unitid, TRUE);

		if (is_object($unitid))
			$unitid = $unitid->id;

		$data->iseditor = $this->unit_model->iseditor($data->unit->courseid);

		if (!is_object($data->unit))
			return FALSE;

		$unit = $data->unit;

		$template = $data->unit->template;

		$objname = FALSE;
		if ($compare_flag == CMS_UNIT_COMPARE_LEFT){
			$objname = 'unitmain';
		}  else {
			$objname = 'right';
		}
		if ($objname != FALSE) {
			$temp = array('action'=>CMS_ACTION_READ,'unitid'=>$unitid,'courseid'=>$unit->courseid,'unittype'=>$unit->type,'parentid'=>$unit->parentid,
							  'unit_template'=>$template, 'use_cssid'=>TRUE );
					//'unit_template'=>$template, 'unit_compare'=>TRUE );
	 		$this->load->library('unit/Unitmain', $temp, $objname);

	 		//$this->$objname->use_cssid = TRUE;
			$data->unitbody = $this->$objname->render($data->meta_flag);

			return $data;
		}
		return FALSE;
	}

}
?>