<?php
/**
 * linkunit.php - Controller for handling link unit.
 *
 * @author $Author: dtong $
 * @version $Id: linkunit.php,v 1.14 2011/05/09 04:48:53 dtong Exp $
 * @copyright Copyright (c) 2010, Tiller Software Co., Ltd.
*/

class Linkunit extends CI_Controller{
	function __construct() {
		parent::__construct();
		$this->access_model->checkaccess_any('unit_read');
	   $this->load->helper('form');
	   $this->load->library('form_validation');
	  	osa_load_lang('linkunit');
		$this->load->model('template/linkunit_model');
		//$this->load->model('sort/sort_model');
	}

	//Function for display link unit.
	function select($extid, $type, $depid=FALSE, $gradeid=FALSE) {
		if ( $extid === FALSE  || $type === FALSE){
			osa_errorlog(__METHOD__ . " -  Invalidate extid and type in Function select link unit ", array('extid'=>$extid,'type'=>$type));
			echo $this->load->view('unit/unit_htmlerror_view', array('errormsg'=>lang('unit_no_permissionmsg')),TRUE);
			exit;
		}
		$linkunit = $this->linkunit_model->get_linkunit($extid,$type);
		$linkunit = $this->check_unithidden($linkunit);
		if ( $linkunit != FALSE ) {
			$notin_ids  = array();
			foreach ($linkunit as $value)
				$notin_ids[] = $value->groupid;
		} else {
			$notin_ids  = array(0);
		}
		$temp_course = $this->linkunit_model->get_course($notin_ids,$depid,$gradeid);
		$unit = array();
		if ( $temp_course != FALSE ){
			foreach($temp_course as $course_row) {
				//check 	access_unitd
				/* if (FALSE && !$this->access_unit($course_row->courseid)){
					if ($course_row->c_hidden == FALSE ){
						$unit[$course_row->name] = $course_row->name;
						if ($course_row->u_hidden == FALSE )
							$unit[$course_row->id] = "&nbsp;- " . $course_row->title;
					}
				}
				else { */
				$unit[$course_row->name] = $course_row->name;
				$unit[$course_row->id] = "&nbsp;- " . $course_row->title;
				//}
			}
		}

		$temp_department = $this->linkunit_model->get_all_department();
		$department[0] = lang('linkunit_all_select');
		foreach($temp_department as $department_row) {
			$department[$department_row->id] = $department_row->name;
		}
		$temp_grade = $this->linkunit_model->get_all_grade();
		$grade[0] = lang('linkunit_all_select');
		foreach($temp_grade as $grade_row) {
			$grade[$grade_row->id] = $grade_row->name;
		}
		//get template identifier by type
		if ( ($templateid = $this->get_template_identifier($type)) != FALSE ){
			$data = $this->linkunit_model->get_data($templateid,$extid);
			$data->templateid = $templateid;
		}

		$data->department		= $department;
		$data->grade       	= $grade;
		$data->unit       	= $unit;
		$data->selectlistitem= $linkunit;
		$data->extid   		= $extid;
		$data->depid   		= $depid;
		$data->gradeid   		= $gradeid;
		$data->type   		   = $type;
		$this->load->view('template/linkunit_view',$data);
	}
	//Function refresh page link unit. If changes department or grade.
	function refresh($extid) {
		if ( !is_numeric($extid) )
			return FALSE;
		$type = FALSE;
		$depid = FALSE;
		$gradeid = FALSE;
		if ( isset($_POST['type']) )
			$type = $_POST['type'];
		if ( isset($_POST['select_departmentid']) )
			$depid = $_POST['select_departmentid'];
		if ( isset($_POST['select_gradeid']) )
			$gradeid = $_POST['select_gradeid'];

			//select($extid, $type, $depid=FALSE, $gradeid=FALSE) {
		$this->select($extid, $type, $depid, $gradeid);

/*
		$linkunit = $this->linkunit_model->get_linkunit($extid,$type);
		$linkunit = $this->check_unithidden($linkunit);
		if ( $linkunit !=FALSE ) {
			$notin_ids  = array();
			foreach ($linkunit as $value)
				$notin_ids[] = $value->groupid;
		} else {
			$notin_ids  = array(0);
		}

		$unit = array();
		$temp_course = $this->linkunit_model->get_course($notin_ids,$depid,$gradeid, true);
		$message_error = '&nbsp;';
		$temp_coursename = "";
		$unit = array();
		if ($temp_course !=FALSE){
			foreach($temp_course as $course_row) {
				//check 	access_unitd
				if (!$this->access_unit($course_row->courseid)){
					if ($course_row->c_hidden == FALSE ){
						$unit[$course_row->name] = $course_row->name;
						if ($course_row->u_hidden == FALSE )
							$unit[$course_row->id] = "&nbsp;- " . $course_row->title;
					}
				}
				else{
					$unit[$course_row->name] = $course_row->name;
					$unit[$course_row->id] = "&nbsp;- " . $course_row->title;
				}

			}
		}
		else {
			$message_error = lang('linkunit_massage');
		}
		$href_save = base_url().'template/linkunit/insert_linkunit/'.$extid;
		$imgsave = osa_imagepath() . 'forward.gif';
		$fieldname  = 'unitid[]';
		$button  = "change_button('img_button', '$imgsave', '" . lang('linkunit_assign_'.$type) . "','{$href_save}','linkunit_form','linkunit'); ";
		$jscript = "onChange=\"$button \"";
		echo '<div id="massage" class="linkunit_massage">'.$message_error.'</div>';
		echo form_dropdown($fieldname, $unit,'',"size='28'  multiple='multiple' style=\" width:450px\"\" $jscript "); */
	}

	//Function Add link unit.
   function insert_linkunit($extid) {
   	if (is_numeric($extid) == FALSE)
			 return FALSE;
		$data = FALSE;
		$value = '';
		$type = FALSE;
		$depid = FALSE;
		$gradeid = FALSE;
		if ( isset($_POST['type']) )
			$type = $_POST['type'];
		if ( isset($_POST['select_departmentid']) )
			$depid = $_POST['select_departmentid'];
		if ( isset($_POST['select_gradeid']) )
			$gradeid = $_POST['select_gradeid'];
		if (isset($_POST['unitid'])){
			$sep = '';
			foreach ($_POST['unitid'] as $row) {
				if (is_numeric($row)){
					$userid = $row;
					$value .= $sep."($extid,$row,$type)";
					$sep = ',';
				}
			}
			if ($value !=FALSE && $value != ''){
				if ($this->linkunit_model->insert_linkunit($value)) {
					if (is_numeric($extid) == FALSE && is_numeric($type) == FALSE)
					  return FALSE;
					$linkunit = $this->linkunit_model->get_linkunit_res_sort($extid,$type);

					if (isset($linkunit) && $linkunit != FALSE){
						foreach ($linkunit as $row) {
							if (is_numeric($row->id)){
								$data->unitid = $extid;
								$data->type = $type;
								//$this->sort_model->add_res($row->id, $data);
							}
						}
					}
				}
			}
		}

		$this->select($extid, $type, $depid, $gradeid);
	}
	//Function delete link unit popup page
	function delete($extid, $unitid) {
		$this->delete_linkunit($extid, $unitid);
	}
	//Function delete link unit display page
   function delete_linkunit($extid, $unitid, $type=FALSE) {
		if (!is_numeric($extid) || !is_numeric($unitid))
			return FALSE;
		$depid = FALSE;
		$gradeid = FALSE;
		if ($type == FALSE &&  isset($_POST['type']))
			 $type = $_POST['type'];
		if	(isset($_POST['select_departmentid']) && isset($_POST['select_gradeid'])) {
			$depid = $_POST['select_departmentid'];
			$gradeid = $_POST['select_gradeid'];
		}
		$this->linkunit_model->delete_linkunit($extid,$unitid,$type);
		if (is_numeric($depid) && is_numeric($gradeid)){
			$this->select($extid,$type,$depid,$gradeid);
		}
	}
	//Function check access unit hidden
	private function check_unithidden($linkunit){
		$data = FALSE;
		if (isset($linkunit) && is_array($linkunit)){
			foreach ($linkunit as $row){
				if ( !$this->access_unit($row->courseid) ){
					if ($row->c_hidden == FALSE && $row->u_hidden == FALSE)
						$data[] = $row;
				}
				else
					return $linkunit;
			}
		}
		return $data;
	}
	//Function check access unit by courseid
	private function access_unit($courseid){
		if (!is_numeric($courseid))
			return FALSE;
		$user = FALSE;
		$this->load->model('auth/login_model');
		$this->load->model('unit/resource_model');
		if ( ($user = $this->login_model->getLogin()) !== FALSE ){
			$isAdminUnitWrite = $this->access_model->checkaccess_any('admin_unit_write',$user,FALSE,FALSE);
			//Get the courses for this user
			$ismycourse = $this->resource_model->is_teacher($user->id, $courseid);
			if ( $ismycourse || $isAdminUnitWrite )
				return TRUE;
		}
		return FALSE;
	}
	//Function get template identifier by type.
	private function get_template_identifier($type) {
		$this->load->library('cms/cms_template/cms_template');
		if (!isset($type) && $type == FALSE){
			osa_errorlog(__METHOD__ . " -  Invalidate Type in Function get templateidentifier ", $type);
			echo $this->load->view('unit/unit_htmlerror_view', array('errormsg'=>lang('unit_no_permissionmsg')),TRUE);
			exit;
		}
		$templateid = $this->cms_template->type_templateid($type);
		if ( $templateid === FALSE ){
			osa_errorlog(__METHOD__ . " -  Invalidate template identifier in Function get templateidentifier ", $templateid);
			echo $this->load->view('unit/unit_htmlerror_view', array('errormsg'=>lang('unit_no_permissionmsg')),TRUE);
			exit;
		}
		return $templateid;
	}
}
?>