<?php
/**
 * login.php - Survey login controller. Most of the code copied from the site login controller.
 *
 * @author $Author: wichai $
 * @version $Id: login.php,v 1.8 2011/05/16 07:59:06 wichai Exp $
 * @copyright Copyright (c) 2009, Tiller Software Co., Ltd.
*/

class Login extends CI_Controller {
	private $survey_parity = 0;
	private $survey_id = 0;

	function __construct() {
		parent::__construct();
		$this->load->model('auth/survey_login_model');
		$this->load->model('survey/survey_model');
		$this->load->helper(array('form', 'url'));
      $this->load->library('form_validation');
      osa_load_lang('login');
      osa_load_lang('survey');
	}

   function index($surveyid=FALSE) {
   	$survey_obj = FALSE;
   	$msg = FALSE;
   	$expired = FALSE;
   	if ( $surveyid ) {
	   	$surveyid = strtolower($surveyid);
			$surveyid = str_replace('o', '0', $surveyid);
			$id_array = osa_hex_id_numval($surveyid);
			$survey_obj = FALSE;
			if ( $id_array !== FALSE ) {
	   		$real_surveyid = $id_array['id'];
				$real_parity = $id_array['parity'];
				$survey_obj = $this->survey_model->get_survey($real_surveyid, $real_parity);
   		}
			if ( !$survey_obj ) {
				$msg = lang('survey_login_invalid_code');
			}
			else {
				if ( $this->survey_model->survey_expired($survey_obj) ) {
					$expired = TRUE;
					$msg = lang('survey_expired_msg');
				}
			}
   	}

   	if ( $this->survey_login_model->isAuthenticated() && $survey_obj && !$expired ) {
   		$home_url = "survey/survey/index/$surveyid";
     		redirect($home_url);
      	exit;
   	}

      $this->form_validation->set_rules('username', 'Username',
         										 'trim|required|min_length[1]|strtolower');
      //Can't use a variable to set lenght of password, has to be hardcoded here
      $this->form_validation->set_rules('password', 'Password', 'required|min_length[1]');
      $this->form_validation->set_rules('surveyid', 'Survey Number', 'trim|required|min_length[1]');
		$form_result = $this->form_validation->run();
		$tmp = set_value('surveyid');
		if ( $tmp ) {
			$surveyid = set_value('surveyid');
			$surveyid = strtolower($surveyid);
			$surveyid = str_replace('o', '0', $surveyid);
			$id_array = osa_hex_id_numval($surveyid);
			$survey_obj = FALSE;
			if ( $id_array !== FALSE ) {
	   		$real_surveyid = $id_array['id'];
				$real_parity = $id_array['parity'];
				$survey_obj = $this->survey_model->get_survey($real_surveyid, $real_parity);
			}
			if ( !$survey_obj ) {
				$msg = lang('survey_login_invalid_code');
			}
			else {
				if ( $this->survey_model->survey_expired($survey_obj) ) {
					$expired = TRUE;
					$msg = lang('survey_expired_msg');
				}
			}
		}
		$this->_get_real_surveyid($surveyid); //populates $this->parity and $this->survey_id
		$home_url = "survey/survey/index/$surveyid";
	   $login_url = "survey/login/index/$surveyid";
	   $form_link = "survey/login/index/$surveyid";

      if ( $form_result == FALSE || !$survey_obj || $expired ) {
      	//Form submit check failed or first empty survey login page
	   	$data = array();
     	 	$site_title = $this->config->item('cms_survey_login_title');
      	$data['site_title'] = $site_title;
      	$data['form_link'] = $form_link;

      	$username = set_value('username');
      	$password = set_value('password');
      	//Just to make sure we are clean
      	if ( !empty($username) && empty($password) )
      		$msg = lang('login_missingpassword');
      	$sess_username = $this->session->flashdata('AUTH_FAILED_USERNAME');
      	if ( $sess_username ) {
      		$username = $sess_username;
      		$msg = lang('login_invalidlogin');
      	}
      	$msg_mode= FALSE;
      	if ( $this->config->item('cms_manage_mode') ){
      		 $msg_mode = lang('login_managemode') ;
      	}
      	if (  $this->config->item('cms_sitestop') ) {
      		$msg_mode = lang('gen_maintenance_msg');
      	}

      	$sess_managemode = $this->session->flashdata('AUTH_FAILED_MANAGE_MODE');
      	if ( $sess_managemode )
      		 $msg = '';  //$msg_mode = lang('login_managemode');

      	$this->survey_login_model->destroyLogin();

      	$data['username'] = $username;
      	$data['msg'] = $msg;
      	$data['msg_mode'] = $msg_mode;
      	$data['surveyid'] = $surveyid;
      	//main_login_view contains multiple views
      	$this->load->view('survey/login_m_view', $data);
      	return;
      }
      else {
      	//Got all the form elements and do the authentication
   	  	$username = set_value('username');
      	$password = set_value('password');
      	if ( $this->survey_login_model->authenticate($username, $password) ) {
      		/*
   			 $this->load->library('cms/cms_template/cms_template_init', array('checkmodtime'=>TRUE));
   			 $this->load->library('cms/memory_table/unit_cache_table', array('check_empty'=>TRUE));
   			 $this->unit_cache_table->auto_update(); //Run the scheduled auto update if necessary
   			 */
             redirect($home_url);
             exit;
      	}
      	else {
				$this->session->set_flashdata('AUTH_FAILED_USERNAME', $username);
				redirect($login_url);
            exit;
        }
      }
   }

   function logout() {
      $this->survey_login_model->destroyLogin();
      redirect('survey/login/index');
      exit;
   }

   //Gets the parity and actual suveryid ($usr_surveyid in hex format)
   //First 2 characters is the parity and then the actual survey id
   private function _get_real_surveyid($usr_surveyid) {
		$this->survey_parity = 0;
		$this->survey_id = 0;
		$ret = osa_hex_id_numval($usr_surveyid);
		if ( !$ret ) {
			return FALSE;
		}
		$this->survey_parity = $ret['parity'];
		$this->survey_id = $ret['id'];
		return TRUE;
   }
}
?>