<?php
/**
 * menu_ict.php - The menu controller for ICT/NETS uploads. This uses the menu_gen_data class for the menu template data generation.
 *
 * @author $Author: dtong $
 * @version $Id: menu_ict.php,v 1.17 2011/04/05 15:18:45 dtong Exp $
 * @copyright Copyright (c) 2009, Tiller Software Co., Ltd.
*/

class Menu_ict extends CI_Controller{
	const BIG_UPLOAD_IMAGE = 'upload.jpg';
	const BIG_UPLOAD_IMAGE_GRAY = 'upload_gray.jpg';

	function __construct() {
		parent::__construct();
		$user = $this->login_model->getLogin();
		$this->access_model->checkaccess_any('homepage_access', $user, TRUE, TRUE);
	   $this->load->model('menu/menu_model');
	   osa_load_lang('menu');
	   osa_load_lang('header');
	   $this->load->library('menu/menu_main');
	}

	/*
	 * function index on the input parameters.
	 *
	 * @param int $res_type
	 * 	The resource type int.
	 * @param int $upload_type
	 * 	The upload type int.
	 * @param int $user_type
	 * 	The user type int.
	 * @param bool $shortname
	 * 	The shortname bool.
	 */
	function index($res_type,$upload_type,$user_type,$shortname=TRUE){
		$data = $this->_gen_template_array($res_type,$upload_type,$user_type, $shortname);
		echo $this->menu_main->generate_html($data);
		@osa_php_session_destroy();
	}

	//$shortname parameter is not used yet. Always default to shortname for now
	private function _gen_template_array($res_type,$upload_type,$user_type,$shortname=TRUE) {
		$id = 'id';
		if ( $this->config->item('cms_use_school_type') ){
			$id = 'schoolid';
			$schools = $this->menu_model->get_grade_type($res_type);
		}
		else{
			$schools = $this->menu_model->getschools();
		}

		$div = 'page_content';
		$menu_data_obj = $this->menu_main->get_gen_data();

		$menu_data_obj->add_header(lang('header_button_uploads_' . $user_type));
		$menu_data_obj->next();
    	foreach($schools as $school) {
    		$href = 'unit/itstd/readonly/'.$res_type.'/'.$upload_type.'/'.$school[$id];
    		$icon = self::BIG_UPLOAD_IMAGE_GRAY;
    		$is_ict_editor =  ( $this->access_model->is_ict_editor($user_type, $school[$id]) );
    		if ( $is_ict_editor ) {
    			$href = 'unit/itstd/sample/'.$res_type.'/'.$upload_type.'/'.$school[$id].'/'.$user_type;
    			$icon = self::BIG_UPLOAD_IMAGE;
    		}
			$title = $school['shortname'] .' '. lang('menu_upload');
    		$menu_data_obj->add_link($title, $icon, $href, $div);
    		$menu_data_obj->next();
		}
	  return $menu_data_obj->get_data();
	}
}
?>