<?php
/**
 * menu.php - The menu controller for the menu tree
 *
 * @author $Author: dtong $
 * @version $Id: menu.php,v 1.23 2011/02/21 06:04:33 dtong Exp $
 * @copyright Copyright (c) 2009, Tiller Software Co., Ltd.
*/

class Menu extends CI_Controller{
	function __construct() {
		parent::__construct();
		osa_load_lang('menu');
		$user = $this->login_model->getLogin();
		//Special case that we can't modify the jstree ajax so we just do redirect when no access or no session
		if ( !$this->access_model->checkaccess_any('homepage_access', $user, TRUE, FALSE)) {
			//redirect('', 'refresh'); //Doesn't work for menu tree
			//echo lang ('menu_nosession');
			//$this->load->library('cms/osa_menutree', array());
			//echo $this->osa_menutree->no_session();
			//For JSTREE
			echo '<ul><li id="no_session" style="color:red">' . lang('menu_jstree_nosession_1') . '<br />' .
				  '&nbsp;&nbsp;&nbsp;&nbsp;' . lang('menu_jstree_nosession_2') . '</i></ul>';
			exit;
		}
		$this->load->model('menu/menu_model');
	   $params = array('user' => $user);
	   $this->load->library('cms/osa_menutree', $params);
	   // Clear cache for IE. Suggestion from jstree forum https://groups.google.com/group/jstree/browse_thread/thread/96c63f2fd24530c9/
	   header("Cache-Control: no-cache, must-revalidate");
      header("Cache-Control: post-check=0, pre-check=0", false);
      header("Pragma: no-cache");
      //header("Expires: ".gmdate("D, d M Y H:i:s", mktime(date("H")-2, date("i"), date("s"), date("m"), date("d"), date("Y")))." GMT");
      header("Expires: Sat, 26 Jul 1997 05:00:00 GMT");
      //header("Last-Modified: ".gmdate("D, d M Y H:i:s")." GMT");
	}

	// make list of courses by grade
	function listgrade($gradeid){
	   $listgrade = $this->osa_menutree->get_coursesbygrade($gradeid);
	   echo $listgrade;
	}

	// make a list of course detail for the grade tree
	function gradecourses_detail($courseid){
		$gradecourses_details = $this->osa_menutree->get_coursesbygrade_details($courseid);
		echo $gradecourses_details;
	 }

	 function listdept($deptid, $catid=FALSE){
	   echo $this->osa_menutree->get_coursesbydept($deptid, $catid);
	 }

	// make a list of course detail for the department tree
	function deptcourses_detail($courseid){
		$deptcourses_details = $this->osa_menutree->get_coursesbydept_details($courseid);
		echo $deptcourses_details;
	 }

	// make tree and list of course detail for the my course tree
	function mycourses_detail($courseid){
		$mycourses_tree = $this->osa_menutree->get_mycourse_details($courseid);
		echo $mycourses_tree;
	}

	//Shows the list of a units in a course
	 function unit($courseid, $prefix="") {
	 	echo $this->osa_menutree->show_units($courseid, $prefix);
	 }

	 function nosession() {
	 	//This will print the no session ajax message
		$this->access_model->checkaccess_any('homepage_access', $user, TRUE, TRUE);
	 }
/*
  	//TODO: Looks like this function is obsolete, take it out later.
	 function menutree() {
	 	$user = $this->login_model->getLogin();
	   $params = array('user' => $user);
	 	$this->load->library('cms/osa_menutree', $params);
	 	$data = array();
	   $data['menutrees'] = $this->osa_menutree;
		$data['user'] = array('user' => $user);
		osa_load_lang('home');
		osa_load_lang('general');
	 	$this->load->view('template/menutree_view', $data);
	 }
*/
	 function totalunit() {
	  	osa_load_lang('home');
		osa_load_lang('general');
	  	$data->menutrees = $this->osa_menutree;
		$this->load->view('template/total_unit_view', $data);
	 }
}
?>