<?php
/**
 * help.php - The help library that interfaces the various help config files
 *
 * @author $Author: dtong $
 * @version $Id: help.php,v 1.8 2011/02/11 09:09:25 dtong Exp $
 * @copyright Copyright (c) 2009, Tiller Software Co., Ltd.
*/

class Help extends CI_Controller{
	function __construct() {
		parent::__construct();
		osa_nosession_ajax_redirect();
		$this->load->library('user_agent');
	}

	function index() {
		$config = $this->config->item('cms_help_config');
		if ( $config === FALSE )
			exit;
		$this->load->library('help/helpmain',array('config'=>$config));
		$help_data = $this->helpmain->get_config();
		if ( $help_data !== FALSE ) {
			if ( $this->config->item('cms_help_notree')) {
				foreach ($help_data as $item) {
					$type = $item['type'];
					switch ($type) {
						case 'link':
							$help_path   = base_url() . $this->config->item('cms_help_path') . $this->config->item('cms_help_config') .  '/';
							$data->divid = 'wait_content';
							$data->url   = base_url() . 'menu/help/pdf/';
							$data->pdf   = str_replace($help_path,'',$item['link']);
							$this->load->view('template/wait_view', $data);
							break;
						}
					}
			}
			else {
				$this->load->view('template/help_view', array('config'=>$help_data));
			}
		}
	}
	function goal() {
		$config = $this->config->item('cms_unit_org').'_goal';
		if ( $config === FALSE )
			exit;
		$this->load->library('help/helpmain',array('config'=>$config));
		$help_data = $this->helpmain->get_config();
		if ( $help_data !== FALSE )
			  $this->load->view('template/help_view', array('config'=>$help_data));
	}

	//Takes a URL and present it in a iframe. Not for PDF only. Any URL will work
	function pdf($siteurl, $link=FALSE) {
		sleep(1);
		$help_path = '';
		if ($link==FALSE)
			$help_path = base_url() . $this->config->item('cms_help_path') . $this->config->item('cms_help_config') .  '/';

		$pdf = $help_path . $siteurl;

		echo  '<iframe name="ifrm" id="ifrm" src="'.$pdf.'" style="width: 100%; height:100%;" scrolling="no" frameborder="0">Sorry, your browser doesn\'t support iframes.</iframe>';
		//header("Location: www.google.com");
		return FALSE;
	}

	//Just a wrapper function so to make the URL not look like for PDF only
	function popup($siteurl, $link=FALSE) {
		return $this->pdf($siteurl,$link);
	}
}
?>