<?php
/**
 * select.php - ajax select optional for mapping searches
 *
 * @author $Author: dtong $
 * @version $Id: select.php,v 1.13 2011/02/11 14:09:30 dtong Exp $
 * @copyright Copyright (c) 2009, Tiller Software Co., Ltd.
*/

class Select extends CI_Controller{
const SELECT_SEPARATOR = '----------';
private $select_size_max = 10;
private $select_size_min = 6;

	function __construct() {
		parent::__construct();
		osa_nosession_ajax_redirect();
		$this->load->library('mapping/Searchmain');
		//osa_load_lang('menu');
		$this->load->model('mapping/Standbench_model');
		$this->load->model('mapping/Eq_model');
		$this->load->helper('form');
		osa_load_lang('mapping');
	}

	function index() {

	}

	function get($table, $deptid, $isAjax=TRUE) {
		sleep(1); //Delay 1 second for better AJAX feel
		$fieldname = '_'.$table;
		$fieldname = $fieldname . '[]';
		$onClick ='';
		$nodatamsg = '';

		if ($table=='standard' && $isAjax ) {	//for standard & benchmark
			$width = ' width="900" style="width: 900px" ';	// change from template

			$select_size = $this->select_size_max ;
			$lang = 'map_standards';
			$data = $this->get_data_array('standbench_form');
		   $onClick = $this->Standbench_model->onClick($data);
			$rows =  $this->Standbench_model->get_standards($table, $deptid);
			$nodatamsg = lang('map_dept_nostd_msg');
		}
		elseif ($table=='essential' && $isAjax ) {   //for Essential Question & Enduring Understandings
			$width = ' width="700" style="width: 700px" ';	// change from template
			$select_size = $this->select_size_max ;
			$lang = 'map_eq_essential';
			$data = $this->get_data_array('eq_form');
		   $onClick = $this->Eq_model->onClick($data);
			$rows =  $this->Eq_model->get_essentials($deptid);
			$nodatamsg = lang('map_dept_noeq_msg');
		}
		elseif ($table=='lthistory' && $isAjax ) {
			$type = '';
			if ($deptid == CMS_LT_HIST_LAST)
				$type = 'last_select';
			elseif ($deptid == CMS_LT_HIST_All)
				$type = 'all_select';

			$searchid = $table;
			$searchdata = array('notForm'=>TRUE,
								'isAjax'=>$isAjax,
								'_handle'=>$table,
								'_form'=>$table.'_form',
								'_divid'=>'map_'.$table,
							    '_search' => array( array('_type'=>$type)));
    		if ($type == '') {
    			echo 'error type';
    			return FALSE;
    		}

    		$html = '';
			$this->searchobj = new input_search();
			$this->searchobj->reset($searchid, $searchdata);
			echo $this->searchobj->render();

			return FALSE;
		}
		else {

			// not use
			/*
			 $select_size = $this->select_size_min ;
			$lang = 'map_benchmark';

			$rows =  $this->Standbench_model->get_benchmarks($table, $deptid);
			*/
		}

		$selections = array('null' => lang($lang) . ':', '' => self::SELECT_SEPARATOR);

		if (!isset($rows) || !is_array($rows) || count($rows)==0) {
			//No data, print msg here
			echo '<font color="red"><b>' . $nodatamsg . '</b></font>';
			return FALSE;
		}
		foreach ($rows as $row) {
		  	$selections[$row['id']] = $row['data'];
		}
		echo form_dropdown($fieldname, $selections, 'xxxZZZ', 'size="' . $select_size . '" ' . $onClick . $width);
		return FALSE;
	}

	function get_data_array($formname, $nexttable='', $clear=1, $target_div='') {
		$select_size = $this->select_size_max ;
		if ($nexttable!='')
			$nexttable .='/';

		$url  = "map/select/get/$nexttable" ;
		$data = array('_clear'=>$clear, '_url'=>$url, '_formname'=>$formname,'_div'=>$target_div);

		return $data;
	}

}
?>