<?php
/**
 * home.php - Main home page controller for CMS
 *
 * @author $Author: dtong $
 * @version $Id: home.php,v 1.25 2011/04/05 15:18:45 dtong Exp $
 * @copyright Copyright (c) 2009, Tiller Software Co., Ltd.
*/
class Home extends CI_Controller {

	function __construct() {
		parent::__construct();
		$this->load->model('menu/menu_model');
		osa_load_lang('home');
		osa_load_lang('general');
		$this->load->library('user_agent');
	}

   function index($extra_data=FALSE){
   	global $g_sess_update, $g_sess_update_ignore_timer;
   	//index() is a normal web page so can't use ajax flag
		 $this->access_model->checkaccess_any('homepage_access', FALSE, FALSE);
	    $user = $this->login_model->getLogin();
	    $params = array('user' => $user);
	    $this->load->library('cms/osa_menutree', $params);

	    //Pass the whole menutree object to the view
	    $data = array();
	    $data['menutrees'] = $this->osa_menutree;
		 $data['user'] = array('user' => $user);

		/*
		 	if (isset($user->userold) != FALSE) {
				$data['username_orig'] = $user->userold->username;
				$data['userold']  = array('userold' => $user->userold);
		 }
	  */

		 //Update the session in case the user does a browser refresh
		 $g_sess_update = TRUE;
		 $g_sess_update_ignore_timer = TRUE;
		 @$this->session->sess_update();
		 $data['load_php_views'] = TRUE;
		 //$data['use_jscript_load_views'] = FALSE;
		 if ( $extra_data && is_array($extra_data) ) {
		 	foreach ($extra_data as $key=>$value) {
		 		$data[$key] = $value;
		 	}
		 }
	    $this->load->view('template/home_m_view', $data);
	    @osa_php_session_destroy();
   }

   function logo() {
   	//This will print ajax redirect message and exit if no session
   	//osa_nosession_ajax_redirect();
   	$this->access_model->checkaccess_any('homepage_access', FALSE, TRUE, TRUE);
   	$this->load->view('template/content_view');
   }
/*
 * //Too much trouble using full refresh. Most of the header buttons stop working becuase menutree is not there any more after refresh
   function admin_config() {
 		$data['menu_url'] = base_url() . 'menu/menu_tree/index/admin';
 		$data['page_content_url'] = base_url() . 'admin/config/index/1';
 		$data['load_php_views'] = FALSE;
 		$data['use_jscript_load_views'] = TRUE;
 		$this->index($data);
   }
*/
}
?>