<?php
/**
 * unitcalendar.php - unitcalendar
 *
 * @author $Author: dtong $
 * @version $Id: unitcalendar.php,v 1.7 2011/04/14 16:33:36 dtong Exp $
 * @copyright Copyright (c) 2009, Tiller Software Co., Ltd.
*/
class Unitcalendar extends CI_Controller{
	function __construct() {
		parent::__construct();
        //Everyone should have at least desc read rights
        $this->access_model->checkaccess_any('course_description_read');
        $this->CI =  get_instance();
        $this->load->model('course/course_model'); // model course
        $this->load->helper('form');
        osa_load_lang('desc');
        $this->load->library('form_validation'); //set validatre
        $this->CI->load->library('cms/osa_chart');
   }

	function process($courseid) {
		if ( !is_numeric($courseid))
			return;
		$coursename = '';
		$data = $this->CI->osa_chart->dataobj();
		$data->divid = 'unit_calendar';
		$data->courseid = $courseid;

		$data->unit = $this->course_model->get_unit_calendar($courseid);
		$unit = $data->unit;
		if (is_array($unit)){
			$unit = $unit[0];
			$coursename = '<span class="">'.$unit->coursename.'</span>';
			$data->addslice();
			$this->CI->osa_chart->prepare_unit_barchart($data);
		  	$this->CI->load->view('course/course_barchart_view.php',
				array('chart'=>$this->CI->osa_chart, 'title'=>$coursename, 'nodata_options'=>'',
					'count' => '1', 'nodata_title'=>'Unit- Calendar', 'divid'=>''));
		}
		else{
			 	$this->CI->load->view('course/course_barchart_view.php');
		}
	}

	function unittotal($courseid) {
		$total = $this->course_model->unit_total($courseid);
		echo $total;
	}
}
?>