<?php
/**
 * site_res.php - Site resources page
 *
 * @author $Author: dtong $
 * @version $Id: site_res.php,v 1.2 2011/04/05 15:18:45 dtong Exp $
 * @copyright Copyright (c) 2011, Tiller Software Co., Ltd.
*/

class site_res extends CI_Controller{
	function __construct() {
		parent::__construct();
		if ( !$this->login_model->isAuthenticated() ) {
			echo osa_ajaxmsg_redirecthome(lang('gen_js_ajaxsessiontimeoutmsg'));
			exit;
		}
	}

	function index($action=CMS_ACTION_READ) {
		$data->html = $this->_load_resource($action);
		if ( $action == CMS_ACTION_READ && $this->access_model->checkaccess_any_noexit('admin_system_management') ) {
			$data->showedit_button = TRUE;
		}
		if ( $action == CMS_ACTION_EDIT ) {
			$data->show_done_button = TRUE;
		}
		$this->load->view('template/site_resources_view', $data);
		@osa_php_session_destroy();
	}

	function edit() {
		if ( $this->access_model->checkaccess_any_noexit('admin_system_management') ) {
			return $this->index(CMS_ACTION_EDIT);
		}
		return $this->index();
	}

	function stage($stagenum, $action, $dummy_unitid=FALSE) {
		echo $this->_load_resource($action, $stagenum);
	}

	//Actual function to load the reosurce
	private function _load_resource($action, $stage_num=FALSE) {

		$this->load->library('unit/Unitmain',
									array('action'=>$action,'unitid'=>1, 'courseid'=>0,
											'unit_template'=>'site_resources') );
		if ( $stage_num === FALSE ) {
			$html = $this->unitmain->render();
			if ( strlen($html) < 50 ) {
				//Do this so we can get rid of the empty box
				return '';
			}
			return $html;
		}
		return $this->unitmain->render_stage($stage_num);
	}
}