<?php
/**
 * school.php - Controller for handling school input pages.
 *
 * @author $Author: dtong $
 * @version $Id: school.php,v 1.13 2011/04/27 05:46:26 dtong Exp $
 * @copyright Copyright (c) 2011, Tiller Software Co., Ltd.
*/
require_once(APPPATH . 'libraries/mapping/display_list.php');
class School extends CI_controller {

	const PAGE_URL = 'admin/school';
	const SCHOOL_DIV = 'school_input';
	const DHTML_WIDTH = 600;
	const DHTML_HEIGHT = 200;
	const TABLE_SCHOOL_NUMBER = 1;
	const TABLE_SCHOOL_TYPE_NUMBER = 2;
	private $divid = 'adminss';

	function __construct() {
		parent::__construct();
		osa_load_lang('admin');
 		$this->access_model->checkaccess_any('admin_system_management');
	   $this->load->library('admin/admin_base');
	   $this->load->library('form_validation');
	   $this->load->model('sort/searchsort_model');
	   $this->load->model('admin/school_model');
	   $this->load->helper('form');
	   osa_php_session_start();
	}

	function index($table_number = self::TABLE_SCHOOL_NUMBER, $type = 'null') {
		if ( !is_numeric($type) && $table_number == self::TABLE_SCHOOL_TYPE_NUMBER ) {
			echo osa_ajaxmsg( lang('gen_internalservererror') );
			exit;
			//return;
		}
		$all_school_data = $this->school_model->get_all_school($table_number);
		$add_button = $this->_get_add_button($table_number, $type);
		$this->load->library('mapping/display_list');
		$display = $this->display_list;
		$display->divid = $this->divid;
		//$display->sort_columns = FALSE;
		$display->allpage = TRUE;
		$display->cssclass_titlerow = 'table_head_col';
		$display->cssclass_datarow1 = 'table_body_row';
		$display->cssclass_datarow2 = 'table_body_row_none';
		$data = new stdClass();

		$data->title = lang('admin_school_title');
		$data->note_red_sign = lang('admin_school_note_red_sign');
		$data->note_gray_sign = lang('admin_school_note_gray_sign');
		$display->titles = array(lang('admin_school_display_name'),
										lang('admin_school_display_shortname'),
										$add_button );
		$display->widths = array('60%', '37%', '3%');//table head width.
		//if table = school_type use this data to override above.
		if ( $table_number == self::TABLE_SCHOOL_TYPE_NUMBER ) {
			$data->title = lang('admin_school_type_title');
			$data->note_red_sign = lang('admin_school_type_note_red_sign');
			$data->note_gray_sign = lang('admin_school_type_note_gray_sign');
			$display->titles = array(lang('admin_school_type_display_name'),
										lang('admin_school_type_display_shortname'),
										$add_button );
		}
		if ($all_school_data) {
			foreach ( $all_school_data as $result ) {
			$row = $this->_get_display_row($result, $table_number, $type);
			if ( !is_array($row) ) {
				osa_errorlog(__METHOD__ . ' got no data row.', array($row, $result));
				continue;
			}
			$display->add($row);
			}
		}
		$display->iswindow = FALSE;
		$display->force_sort = TRUE;
		$display->change_sort_direction = TRUE;
		$display->prepare_page();
		$data->display = $display;
		$this->load->view('admin/school_list_view', $data);
	}

	private function _get_add_button($table_number, $type) {
		//add button config
		$width = self::DHTML_WIDTH;
		$height = self::DHTML_HEIGHT;
		$add_url = self::PAGE_URL . '/add/' . $table_number . '/' . $type;
		$div = self::SCHOOL_DIV;
		$image_name = osa_imagepath() . 'add_24.gif';

		$add_title = lang('admin_school_add_title');
		$image_title = lang('admin_school_add_title');
		if ( $table_number == self::TABLE_SCHOOL_TYPE_NUMBER ) {
			$add_title = lang('admin_school_type_add_title');
			$image_title = lang('admin_school_type_add_title');
		}

		return $this->admin_base->newDhtmlWindow($add_url, $add_title, $width, $height, $div, $image_name, $image_title);
	}

	private function _get_display_row($result, $table_number, $type) {
		if ( !is_array($result) && count($result) <= 0 ) {
			return FALSE;
		}
		//data from query.
		$school_id = $result->id;
		$school_name = $result->name;
		$school_shortname = $result->shortname;

		$edit_title = lang('admin_school_edit_title');
		$edit_link = lang('admin_scholl_edit_link');
		$delete_warning = lang('admin_school_delete_warning');
		$delete_title = lang('admin_school_delete_title');

		if ( $table_number == self::TABLE_SCHOOL_TYPE_NUMBER ) {
			$edit_title = lang('admin_school_type_edit_title');
			$edit_link = lang('admin_scholl_type_edit_link');
			$delete_warning = lang('admin_school_type_delete_warning');
			$delete_title = lang('admin_school_type_delete_title');
		}

		//edit button config
		$edit_url = self::PAGE_URL . '/edit/' . $table_number . '/' . $type . '/' . $school_id;
		$edit_image = osa_imagepath() . 'edit_16.gif';
		$edit_button = $this->admin_base->newDhtmlWindow($edit_url, $edit_title,
																		 self::DHTML_WIDTH, self::DHTML_HEIGHT, self::SCHOOL_DIV,
																		 $edit_image, $edit_link);
		//delete button config
		$del_url = self::PAGE_URL . '/delete/' . $table_number . '/' . $type . '/' . $school_id;
		$del_image = osa_imagepath() . 'x.gif';
		$del_button = $this->admin_base->delTarget($del_url, 'page_content', $delete_warning,
																 $del_image, $delete_title);

		if ( $this->_school_relate_existing($school_id, $table_number) ) {
			$del_image = osa_imagepath() . 'x_dis.gif';
			$del_button = '<img src="'.$del_image.'" />';
		}
		//display button.
		$link = "<nobr>$del_button $edit_button</nobr>";
		return array($school_name, $school_shortname, $link);
	}

	function add($table_number, $type){
		$this->edit($table_number, $type, FALSE, CMS_ADMIN_ADD);
	}

	function edit($table_number, $type, $school_id, $action = CMS_ACTION_EDIT) {
		if ( !isset($action) ) {
			echo osa_ajaxmsg( lang('gen_internalservererror') );
			exit;
		}
		$data = new stdClass();
		$sort_value = array();
		$data->page = self::PAGE_URL;
		$data->action = $action;
		$data->table = $table_number;
		if ( $type != 'null' && is_numeric($type)) {
			$data->type = $type;
		}

		if ( $action == CMS_ADMIN_EDIT ){
			$get_school = $this->school_model->get_school($school_id, $table_number);
			$data->school_data = $get_school;
			$result = $get_school[0];
			$selected_title = $result->name;
		}
		if ( $action == CMS_ADMIN_ADD ){
			$selected_title = lang('admin_school_add_new_title');
			if ( $table_number == self::TABLE_SCHOOL_TYPE_NUMBER ) {
				$selected_title = lang('admin_school_type_add_new_title');
			}
		}
		$data->selected_title = $selected_title;

		$this->load->view('admin/school_input_view', $data);
	}

	//passing value from ADD page
	function insert($table_number){
		$this->_db_update_handle(CMS_ADMIN_INSERT, $table_number);
	}

	//passing value from EDIT page
	function update($table_number) {
		$this->_db_update_handle(CMS_ADMIN_UPDATE, $table_number);
	}

	//delete function
	function delete($table_number, $type, $school_id){
		if ( is_numeric($school_id) == FALSE || $this->_school_relate_existing($school_id, $table_number) ){
			echo osa_ajaxmsg( lang('gen_internalservererror') );
			exit;
		}
		$result = $this->school_model->delete_school($school_id, $table_number);

		if ( $table_number == self::TABLE_SCHOOL_TYPE_NUMBER ) {
			$this->index($table_number, $type);
		}
		else {
			$this->index($table_number);
		}
	}

	//check form input & form action
	private function _db_update_handle($action, $table_number){
		if ( $action != CMS_ADMIN_INSERT && $action != CMS_ADMIN_UPDATE ){
			echo osa_ajaxmsg( lang('gen_internalservererror') );
			exit;
		}

		$post_record_data = array();
		$school_id = FALSE;
		$post_arraykeys = array_keys($_POST);
		$this->form_validation->set_rules('shortname', 'lang:admin_school_column_shortname', 'required');
		$this->form_validation->set_rules('name', 'lang:admin_school_column_name', 'required');

		if ( ! $this->form_validation->run() ) {
			echo osa_ajaxmsg( validation_errors() );
			exit;
		}
		//check if table = school_type
		if ( $table_number == self::TABLE_SCHOOL_TYPE_NUMBER ) {
			// type must be integer.
			if ( osa_is_int($_POST['type']) === FALSE){
				echo osa_ajaxmsg(lang('admin_school_error_type'));
				exit;
	 		}
		}

		foreach ( $post_arraykeys as $arrkey ){
			if ( $arrkey != 'bustcache' && $arrkey != 'id' ) {
				$value = trim($_POST[$arrkey]);
				$post_record_data[$arrkey] = $value;
			}
			else if ( $arrkey == 'id' ){
				$school_id = $_POST[$arrkey];
			}
		}

		if ( $action == CMS_ADMIN_UPDATE ) {
			if ( $school_id == FALSE || is_numeric($school_id) == FALSE) {
				echo osa_ajaxmsg( validation_errors() );
				exit;
			}
			$result = $this->school_model->update_school($school_id, $post_record_data, $table_number);
		}
		else if ( $action == CMS_ADMIN_INSERT ){
			$result = $this->school_model->insert_school($post_record_data, $table_number);
		}
	}

	//check the relationship between $school_id is used by other table
	//return boolean
	private function _school_relate_existing($school_id, $table_number) {
		return ($this->school_model->check_school_relation_exists($school_id, $table_number));
	}
}

