<?php
/**
 * department.php - Controller for handling input pages.
 *
 * @author $Author: dtong $
 * @version $Id: department.php,v 1.40 2011/05/18 05:52:16 dtong Exp $
 * @copyright Copyright (c) 2009, Tiller Software Co., Ltd.
*/
require_once(APPPATH . 'libraries/mapping/display_list.php');
class Department extends CI_Controller{
	//This is used as the session variable name. All admin features use this name
   private $divid = 'adminss'; //Used to be 'department'
   //To start a new display session or not
   private $new_display_session = FALSE;

	function __construct() {
		parent::__construct();
		 $this->access_model->checkaccess_any('admin_system_management');
	    $this->load->model('admin/department_model');
	    osa_load_lang('admin');
	    $this->load->helper('form');
	    $this->load->library('form_validation');
	    $this->load->library('admin/admin_base');
	    $this->load->library('pagination');
	    $this->load->model('sort/searchsort_model');
	    osa_php_session_start();
	}

	function index() {
		$this->new_display_session = TRUE;
		$this->refresh(CMS_ADMIN_ENABLE);
	}
	function refresh($enableflag,$filter=FALSE,$page_con=FALSE) {
		if ( $enableflag != CMS_ADMIN_DISABLE && $enableflag != CMS_ADMIN_ENABLE && $enableflag != CMS_ADMIN_ALL ) {
			echo osa_ajaxmsg(lang('gen_internalservererror'));
			exit;
		}

		//Add Config
		$url_add	 = 'admin/department/add/'.$enableflag;
		$div		 = 'department_input';
		$width		 = 600;
		$height		 = 400;
		$title_add	 = lang('admin_department_add_title');
		$imgaddname	 = osa_imagepath() . 'add_24.gif';
		$imgaddtitle = lang('admin_department_title_add');
	    $imgeadd     = $this->admin_base->newDhtmlWindow($url_add, $title_add, $width, $height, $div , $imgaddname,$imgaddtitle );

	 	//$divid    = 'department' ;
   		//$display  = $this->admin_base->init_display(CMS_ADMIN_DEPARTMENT_TYPE, $enableflag,$this->divid);
		if ( $this->new_display_session ) {
			$display = & $this->admin_base->init_display(CMS_ADMIN_DEPARTMENT_TYPE, $enableflag, $this->divid);
			$display->column_use_striptag[0] = TRUE;
		}
		else {
			$this->load->library('search/searchutil');
			$display = & $this->searchutil->get_session($this->divid);
			$display->selectlistitem = $enableflag;
			$display->reset_data();
		}
   	$display->type = '';
   	$display->menu  	 = lang('admin_menu_department');
   	//$display->search  	 = lang('admin_department_search');
   	$display->pagetitle  = lang('admin_department_title');
   	$display->titles     = array(lang('admin_department_display_name'),
   				                 lang('admin_department_display_shortname'),
   				                 lang('admin_department_display_description'),
   				                 lang('admin_department_display_enabled'),
   				                 $imgeadd
   				                 ) ;
		$display->widths = array('37%', '15%', '35%', '10%', '3%');

		$page			= 'page_content';
		$display->refresh = $page;
		$display->strand=array();
		$display->data_dep_sch =array();
		$display->standard =array();
		$display->filter=FALSE;
   	if ($filter != FALSE) {
			$display->filter = $filter;
   	}
		else {
			if (isset($_POST['filter']))
			$display->filter = $_POST['filter'];
		}
		//Fix (issue: 130) (issue:131)
		if ( !empty($display->filter) ) {
			$display->filter = rawurldecode($display->filter);
		}

		$splits = $this->admin_base->split($display->filter);
		$data     = $this->department_model->get_alldepartment($enableflag,$display->filter);
		if ($data != FALSE) {
			foreach ($data as $rows) {
				if ($rows->shortname == '')
				    $rows->shortname  ='&nbsp;';

				if ($rows->description == '')
				    $rows->description  ='&nbsp;';

				$enabled = $rows->enabled;
				if ($rows->enabled == CMS_ADMIN_DISABLE){
					$rows->enabled  = '<div class="hide">'.lang('admin_list_convert_disabled').'</div>';
				    $imgdelname		= osa_imagepath() . 'enabled_16.gif';
				    $imgdeltitle	= lang('admin_department_title_enable');
				    $massage		= lang('admin_department_message_enable');
				}elseif ($rows->enabled == CMS_ADMIN_ENABLE){
					$rows->enabled  = '<div class="show">'.lang('admin_list_convert_enabled').'</div>';
				    $imgdelname		= osa_imagepath() . 'disable_16.gif';
				    $imgdeltitle	= lang('admin_department_title_disable');
				    $massage		= lang('admin_department_message_disable');
				}

				//Edit Config
				$url_edit		= 'admin/department/edit/'.$rows->id.'/'.$enableflag;
				$div			= 'department_input';
				$title_edit		= lang('admin_department_edit_title');
				$imgeditname	= osa_imagepath() . 'edit_16.gif';
				$imgedittitle	= lang('admin_department_title_edit');
				$linktitle		= lang('admin_department_link_title');

				//Delete Config
				$url_del		= 'admin/department/delete/'.$rows->id.'/'.$enabled.'/'.$enableflag;

				$highlight_name = $this->admin_base->highlight($splits, $rows->name);

			    $linkname = $this->admin_base->linkDhtmlWindow($url_edit, $title_edit, $width, $height, $div ,$highlight_name,$linktitle );
			    $imgedit  = $this->admin_base->newDhtmlWindow($url_edit, $title_edit, $width, $height, $div , $imgeditname,$imgedittitle );
			    $imgdel   = $this->admin_base->delTarget($url_del, $page ,$massage,$imgdelname, $imgdeltitle);
			    //$imgedit  = '<span class="department_col_body_center_edit">' .$imgedit. '</span>';
			    //$imgdel   = '<span class="department_col_body_center_del">'  .$imgdel. '</span>';


		 		$temp = array($linkname , $rows->shortname, $rows->description, $rows->enabled, "<nobr>$imgdel $imgedit</nobr>");
				$display->add($temp);
			}
		}
		$display->allpage = TRUE;
 		//$this->admin_base->load_view($display);
 		$display->iswindow = FALSE;
		$display->force_sort = TRUE;
      $display->prepare_page();
      $data = new stdClass();
      $data->display = & $display;
      $data->not_show_search_box = TRUE;
      echo $this->load->view('tablelist/admin_list_view', $data, TRUE);
	}

	function insert() {
		$data = array();
	 	$departmentid = FALSE;
	    $keys = array_keys($_POST);

		$this->form_validation->set_rules('name', 'Name', 'required') ;
		if ( ! $this->form_validation->run()) {
			echo osa_ajaxmsg(validation_errors());
		    exit();
		}
	    foreach ($keys as $key) {
			if ($key != 'bustcache' && $key != 'id') {
	    	 	 $value = trim($_POST[$key]);
	    	 	 if ($key == 'Enabled' ) {
		    	  	 if ($_POST[$key] == 'on')
		    		 	 $value = 1;
		    		 else
		    			 $value = 0;
	    	 	 }
	    		 $data[$key] = $value;
			}
			elseif ($key == 'id') {
				$departmentid = $_POST[$key];
			}
	    }


	  $result= $this->department_model->add_department($data);

	   	if ($result==1)
			$result = 'success';
		echo $result;

	}

	function update() {
		$data = array();

	    $departmentid = FALSE;
	    $keys = array_keys($_POST);

		$this->form_validation->set_rules('name', 'Name', 'required') ;
		if ( ! $this->form_validation->run()) {
			echo osa_ajaxmsg(validation_errors());
		    exit();
		}


	    foreach ($keys as $key) {
			if ($key != 'bustcache' && $key != 'id') {
	    	 	 $value = trim($_POST[$key]);
	    	 	 if ($key == 'Enabled') {
		    	  	 if ($_POST[$key] == 'on')
		    		 	 $value = 1;
		    		 else
		    			 $value = 0;
	    	 	 }

	    		 $data[$key] = $value;
			}
			elseif ($key == 'id') {
				$departmentid = $_POST[$key];
			}
	    }

 		if ( $departmentid == FALSE || is_numeric($departmentid)== FALSE ) {
				echo osa_ajaxmsg('error' . $departmentid);
				exit;
 		}

		$result=$this->department_model->update_department($departmentid , $data);
		if ($result==1)
			$result = 'success';
		echo $result;
	}

    function add($enableflag=FALSE) {
     	$this->edit(FALSE, $enableflag, CMS_ADMIN_ADD);
	}

	function edit($departmentid ,$list, $action=CMS_ACTION_EDIT) {
		if ( is_numeric($list) == FALSE || $list < CMS_ADMIN_DISABLE || $list > CMS_ADMIN_ALL ) {
				// show error message
				echo 'error list';
				return FALSE;
		}

	    $data = FALSE;
	    $data->page     = $this->admin_base->getpage(CMS_ADMIN_DEPARTMENT_TYPE);
        $data->selectlistitem = $list;
	   	$department = $this->department_model->get_department($departmentid);
	   	$data->action = $action;
	   	$data->data   = $department;

		if ($action == CMS_ADMIN_EDIT ) {
   			$row= $department[0];
   			$selected_display 	= $row->name;
		}elseif ($action == CMS_ADMIN_ADD ) {
     		$selected_display=lang('admin_department_add_head');
		}
	   $data->selected_display   = $selected_display;

		//$divid = 'department' ;
		$temp  = $this->searchsort_model->getSort($this->divid);
		$data->filter=$temp->filter;
    	if ($temp->filter==FALSE && $temp->filter=='')
    		$data->filter = FALSE;

	   $this->load->view('admin/department_input_view',$data);

	}

	function delete($departmentid, $enabled, $list) {
		if ( is_numeric($departmentid)==FALSE ||  is_numeric($enabled)==FALSE ||  is_numeric($list)==FALSE ) {
			// show error message
			echo 'error list';
			return FALSE;
		}

		if ( $enabled < CMS_ADMIN_DISABLE && $enabled > CMS_ADMIN_ENABLE ) {
			// show error message
			echo 'error list';
			return FALSE;
		}

		if ($enabled==CMS_ADMIN_DISABLE)
			$enabled= CMS_ADMIN_ENABLE;
		else
		    $enabled= CMS_ADMIN_DISABLE;

		//$divid = 'department' ;
		$department  = $this->searchsort_model->getSort($this->divid);

	    $filter= FALSE;
	    if ($department->filter!=FALSE && $department->filter!='')
	    $filter=$department->filter;
	   $this->department_model->del_department($departmentid,$enabled);
	   $this->refresh($list,$filter);
	}
/*
	function search() {
	 $keys = array_keys($_POST);
	    foreach ($keys as $key) {
	    	if ($key != 'bustcache') {
	    		$value = trim($_POST[$key]);
				if ($key == 'filter'){
					$filter = $value;
				}
				elseif ($key == 'filters'){
					$enableflag = $value;
				}

			}
	    }

    	echo $enableflag.'/'.$filter;
	}
*/
	function search() {
		$this->access_model->checkaccess_any('admin_system_management');
		$this->load->library('search/searchutil');
		$display = & $this->searchutil->get_session($this->divid);
		//$display->selectlistitem = $enableflag;
		$filter = FALSE;
		if ( array_key_exists('filter', $_REQUEST) ) {
			$filter = $_REQUEST['filter'];
		}
		$this->refresh($display->selectlistitem, $filter);
	}

}
?>