<?php
/**
 * benchmark.php - Controller for handling input pages.
 *
 * @author $Author: dtong $
 * @version $Id: benchmark.php,v 1.46 2011/05/09 11:59:58 dtong Exp $
 * @copyright Copyright (c) 2009, Tiller Software Co., Ltd.
*/

require_once(APPPATH . 'libraries/mapping/display_list.php');
class Benchmark extends CI_Controller{
	//The form ids are same as DB column names. Limit table update to these keys only.
	private $allowed_post_keys = array('courseid','mingradeid','maxgradeid','standardid','type','enabled','importid','data');
	//This is used as the session variable name. All admin features use this name
   private $divid = 'adminss'; //Used to be 'benchmark'
   //To start a new display session or not
   private $new_display_session = FALSE;

	function __construct() {
		parent::__construct();
		$this->access_model->checkaccess_any('admin_system_management');
	   $this->load->model('admin/benchmark_model');
	   $this->load->model('admin/standard_model');
	   $this->load->helper('form');
	   osa_load_lang('admin');
	   $this->load->library('admin/admin_base');
	   $this->load->library('menu/menu_main');
	   $this->load->library('form_validation');
	   $this->load->model('sort/searchsort_model');
	   osa_php_session_start();
	}

	//$index can be just an int or int_int like 7_2. The 2nd int is for sub index other than 1
	function index($type,$index=FALSE,$page_con='page_content', $dep_schid=FALSE, $strandid=FALSE, $standardid=FALSE) {
		if ( !is_numeric($type) )
			return FALSE;
		$this->new_display_session = TRUE;
		$this->refresh(CMS_ADMIN_ENABLE, $type,$page_con,$dep_schid,$strandid,$standardid,FALSE,$index);
	}

	function refresh($enableflag, $type=FALSE, $page_con=FALSE, $dep_schid=FALSE,
						  $strandid=FALSE, $standardid=FALSE, $filter=FALSE, $index=FALSE) {

		//if ($enableflag== FALSE || is_numeric($enableflag) == FALSE && isset($_POST['filters'])) {
	 		//$enableflag = $_POST['filters'];
	 	//}
		if ( $enableflag != CMS_ADMIN_DISABLE && $enableflag != CMS_ADMIN_ENABLE && $enableflag != CMS_ADMIN_ALL ) {
			echo osa_ajaxmsg(lang('gen_internalservererror'));
			exit;
		}

   		 //Add Config
   	$this->CI = & get_instance();
		$url_add	= 'admin/benchmark/add/'.$enableflag;
		//$divid = 'benchmark' ;
		$div = 'benchmark_input_benchmark';
		$formname = 'admin_search_form_benchmark';
		$page	= 'page_content';
		$width = 800;
		$height = 450;
		$title_add = lang('admin_benchmark_add_title');

		if ( $this->new_display_session ) {
			$display = & $this->admin_base->init_display(CMS_ADMIN_BENCHMARK_TYPE, $enableflag, $this->divid);
			$display->column_use_striptag[0] = TRUE;
		}
		else {
			$this->load->library('search/searchutil');
			$display = & $this->searchutil->get_session($this->divid);
			$display->reset_data();
		}
		$_title = FALSE;
   	$_schoolflag = FALSE;
   	//Somehow the original index needs to be preserved in session
   	if ($index == FALSE){
			//$temp = $this->CI->searchsort_model->getSort($this->divid);
			//$index = $temp->index;
			$index = $this->CI->session->userdata('adminbenchmark_index');
   	}
   	else {
   		//$display->index = $index;
   		//TODO: This will never get deleted from CI session, Bad logic.
   		$this->CI->session->set_userdata(array('adminbenchmark_index'=>$index));
   	}

		//Hack to allow the sub/second index to pass in
		$sub_index = 1;
		if ( $index !== FALSE ) {
			$tmp_index = explode('_',$index);
			if ( count($tmp_index) > 1 ) {
				$index = $tmp_index[0];
				$sub_index = $tmp_index[1];
			}
		}

   	$temp = $this->menu_main->get_template('admin');
		$template = $temp[$index][$sub_index];
		if (osa_get_template_value($template,'_title') != FALSE )
			$_title  = osa_get_template_value($template,'_title');
		if (osa_get_template_value($template,'_schoolflag') != FALSE )
			$_schoolflag  = osa_get_template_value($template,'_schoolflag');
		$_table = FALSE;
		if (osa_get_template_value($template,'_table') != FALSE )
			$_table  = osa_get_template_value($template,'_table');
		$display->table = $_table;
		$display->pagetitle = $_title;
   	$display->schoolflag = $_schoolflag;

		$imgaddtitle = lang('admin_standard_title_add_dis_dept_11');
		if (isset($_schoolflag) && $_schoolflag != FALSE)
		 	$imgaddtitle = lang('admin_standard_title_add_dis_scho_8');
		$imgaddname = osa_imagepath().'add_dis_24.gif';
		$imgeadd = "<a><img src=\"$imgaddname\" title=\"$imgaddtitle\" border='0'></a>";

		if ((isset($_POST['dep_schid']) && $_POST['dep_schid']!=0 && isset($_POST['strandids']) &&
			 $_POST['strandids']!=0)|| $dep_schid!=FALSE || $strandid!=FALSE) {
			$imgaddname	= osa_imagepath().'add_24.gif';
			$imgaddtitle = lang('admin_benchmark_title_add');
			$imgeadd = $this->admin_base->newDhtmlWindow($url_add, $title_add, $width, $height, $div , $imgaddname,$imgaddtitle );
		}

   	$display->menu = lang('admin_menu_benchmark');
   	$display->search = lang('admin_benchmark_search');
   	$display->pagetitle = $_title;

		if (isset($_schoolflag) && $_schoolflag != FALSE){
			$display->titles = array(lang('admin_benchmark_display_benchmark'),
   					                 lang('admin_benchmark_display_standard'),
   					                 lang('admin_benchmark_display_enabled'),
   					                 $imgeadd,
   					                 );
 			$display->widths  = array('43%', '43%', '10%', '4%');
		}
		else{
			$display->titles = array(lang('admin_benchmark_display_benchmark'),
   					                lang('admin_benchmark_display_standard'),
   					                lang('admin_benchmark_display_mingradeid'),
   					                lang('admin_benchmark_display_maxgradeid'),
   					                lang('admin_benchmark_display_enabled'),
   					                $imgeadd,
		   					                 ) ;
			$display->widths = array('35%', '32%', '10%', '10%', '10%', '3%');
		}

		$display->filter = FALSE;
   	if ($filter != FALSE)
			$display->filter = $filter;
		else {
			if (isset($_POST['filter']))
				$display->filter = $_POST['filter'];
		}

   	$display->type = $type;
   	$display->refresh = 'benchmark_list';
  		$display->selectid = FALSE;
  		$display->selectstandardid = FALSE;
  		$display->dep_schid = FALSE;
   	if ($page_con == 'page_content')
			$display->refresh  = $page;
		if ($strandid != FALSE)
			$display->selectid = $strandid;
		else {
			if (isset($_POST['strandids']))
				$display->selectid = $_POST['strandids'];
		}
		if ($standardid != FALSE)
			$display->selectstandardid   = $standardid;
		else {
			if (isset($_POST['standardid']))
				$display->selectstandardid = $_POST['standardid'];
		}

		if ($dep_schid != FALSE)
			$display->dep_schid = $dep_schid;
		else {
			if (isset($_POST['dep_schid']))
				$display->dep_schid = $_POST['dep_schid'];
		}
		//TODO: Both are the same value...
		$display->enableflag = $enableflag;
		$display->selectlistitem = $enableflag;

		//keep last department and clear strand
		$display->filter_key_1 = false;
		if (isset($_POST['filter_key_1']) && is_numeric($_POST['filter_key_1']) && $_POST['filter_key_1'] != $display->dep_schid ) {
			$display->filter_key_1 = $_POST['filter_key_1'] ;
			$display->selectid = FALSE;
			$display->selectstandardid = FALSE;
		}
		$display->filter_key_1 = $display->dep_schid;

		//keep last strand and clear standard
		$display->filter_key_2 = false;
		if (isset($_POST['filter_key_2']) && is_numeric($_POST['filter_key_2']) && $_POST['filter_key_2'] != $display->selectid ) {
			$display->filter_key_2 = $_POST['filter_key_2'] ;
			$display->selectstandardid = FALSE;
		}
		$display->filter_key_2 = $display->selectid;

		if (isset($_schoolflag) && $_schoolflag != FALSE){
			$display->search_dep_sch = lang('admin_search_school');
			$data_dep_sch = $this->benchmark_model->get_school($type,$display->dep_schid,$_table );
			$display->data_dep_sch = $this->benchmark_model->get_school($type,FALSE,$_table);
			//$display->strand = $this->benchmark_model->get_strand($display->type,FALSE,$display->dep_schid);
			$display->strand = $this->standard_model->get_strand($display->type,FALSE,$display->dep_schid);
   		$display->standard = $this->benchmark_model->get_standard($display->type,$display->selectid,FALSE,$display->dep_schid);
			$data = $this->benchmark_model->get_allbenchmark($enableflag,$display->type,$display->filter,FALSE,
							$display->dep_schid,$display->selectid,$display->selectstandardid,$_table);
			$display->notice = lang('admin_benchmark_add_schoolnotice');
		}
		else{
			$display->search_dep_sch = lang('admin_search_department');
			$data_dep_sch = $this->benchmark_model->get_department($display->dep_schid );
			$display->data_dep_sch = $this->benchmark_model->get_department();
			//$display->strand = $this->benchmark_model->get_strand($display->type,$display->dep_schid,FALSE );
			$display->strand = $this->standard_model->get_strand($display->type,$display->dep_schid,FALSE );
   		$display->standard = $this->benchmark_model->get_standard($display->type,$display->selectid,$display->dep_schid,FALSE);
			$data = $this->benchmark_model->get_allbenchmark($enableflag,$display->type,$display->filter,$display->dep_schid,FALSE,
							$display->selectid,$display->selectstandardid);
			$display->notice = lang('admin_benchmark_add_departmentnotice');
		}

		if (is_array($data_dep_sch)){
			$row=$data_dep_sch[$display->dep_schid ];
			$display->dep_search = $row;
		}
		if (is_array($display->strand) && isset($display->strand) ){
			$display->strand_search = $display->strand;
		}

   	$splits = $this->admin_base->split($display->filter);
		if ($data != FALSE) {
			$first_loop = TRUE;
			foreach ($data as $rows) {
				$enabled = $rows->enabled;
				$imgdelname = osa_imagepath() . '%s';
				$imgdeltitle = '%s';
				if ($rows->enabled == CMS_ADMIN_DISABLE){
					$rows->enabled = '<div class="hide">'.lang('admin_list_convert_disabled').'</div>';
				    //$imgdelname = osa_imagepath() . 'enabled_16.gif';
				    //$imgdeltitle = lang('admin_benchmark_title_enable');
				    $massage = lang('admin_benchmark_message_enable');
				}elseif ($rows->enabled == CMS_ADMIN_ENABLE){
					$rows->enabled = '<div class="show">'.lang('admin_list_convert_enabled').'</div>';
				    //$imgdelname = osa_imagepath() . 'disable_16.gif';
				    //$imgdeltitle = lang('admin_benchmark_title_disable');
				    $massage = lang('admin_benchmark_message_disable');
				}

				//Delete Config
				//$url_del	= 'admin/benchmark/delete/'.$rows->id.'/'.$enabled.'/'.$enableflag.'/'.$display->type;


				//Edit Config
				//$url_edit = 'admin/benchmark/edit/'.$rows->id.'/'.$enableflag;

				$title_edit = lang('admin_benchmark_edit_title');
				$imgeditname = osa_imagepath() . 'edit_16.gif';
				$imgedittitle = lang('admin_list_title_edit');



			   if ( $this->config->item('cms_lt_importid_support') && !empty($rows->benchmark_importid) && !empty($rows->standard_importid)) {
			   	$highlight_name = $this->admin_base->highlight($splits, "$rows->benchmark_importid $rows->data");
			   	$standard_text = "$rows->standard_importid $rows->standard";
			   }
			   else {
			   	$highlight_name = $this->admin_base->highlight($splits, $rows->data);
			   	$standard_text = $rows->standard;
			   }

			   if ( $first_loop ) {
			   	//Only execute this during the very first loop. It only needs to run once but it needs data from inside the loop
			   	$url_del	= 'admin/benchmark/delete/%s/%s/'.$enableflag.'/'.$type;
					$url_edit = 'admin/benchmark/edit/%s/' . $enableflag;
					$imgedit  = $this->admin_base->newDhtmlWindow($url_edit, $title_edit, $width, $height, $div, $imgeditname, $imgedittitle );
			  		$imgdel   = $this->admin_base->delTarget($url_del, $display->refresh  ,$massage,$imgdelname, $imgdeltitle,$formname);
					$tmp_buttons = "<nobr>$imgdel $imgedit</nobr>";
					if (isset($_schoolflag) && $_schoolflag != FALSE){
						$hidden_data_index = 3;
						$display->add_urllink_template_str(3, $tmp_buttons);
					}
					else {
						$hidden_data_index = 5;
						$display->add_urllink_template_str(5,$tmp_buttons);
					}
			   }
			   $first_loop = FALSE;
			   $tmp_buttons = '';
			   //For the 2 %s in $url_del and $url_edit
			   if ( $enabled ) {
			   	$hidden_data = "$rows->id,$enabled,$rows->id,$enabled,'disable_16.gif','" . lang('admin_benchmark_title_enable') .
			   						"',$rows->id,$rows->id";
			   }
			   else {
			   	$hidden_data = "$rows->id,$enabled,$rows->id,$enabled,'enabled_16.gif','" . lang('admin_benchmark_title_disable') .
			   						"',$rows->id,$rows->id";
			   }

			   if (isset($_schoolflag) && $_schoolflag != FALSE){
				   if ( !$rows->strand_enabled || !$rows->standard_enabled) {
				   	$standard_text = "<font color=\"grey\">{$standard_text}</font>";
				   }
			    	$temp = array($highlight_name, $standard_text, $rows->enabled, $tmp_buttons);
			    	$display->add_hidden_data($hidden_data_index, $temp, $hidden_data);
			    }
			    else {
			     	if ( !$rows->department_enabled || !$rows->strand_enabled || !$rows->standard_enabled) {
			   	 	$standard_text = "<font color=\"grey\">{$standard_text}</font>";
			    	}
			    	$temp = array($highlight_name, $standard_text, $rows->mingrade, $rows->maxgrade,
			    					  $rows->enabled, $tmp_buttons);
			    	$display->add_hidden_data($hidden_data_index, $temp, $hidden_data);
			    }

				$display->add($temp);
			}
		}
		$this->_truncate_standard_text($display->standard);
 		$this->admin_base->load_view($display);
	}

	function insert() {
		$this->form_validation->set_rules('standardid', 'Standard ID', 'trim|required|is_numeric') ;
		$this->form_validation->set_rules('data', 'Data', 'trim|required') ;
		$this->form_validation->set_rules('mingradeid', 'Minimum Grade', 'trim') ;
		$this->form_validation->set_rules('maxgradeid', 'Maximum Grade', 'trim') ;
		$run_result = $this->form_validation->run();

		$mingrade = set_value('mingradeid');
		$maxgrade = set_value('maxgradeid');
		//$maxgrade and $mingrade are not always present. But if they do then they have to be > 0
		if ( !$run_result || (is_numeric($maxgrade) && is_numeric($mingrade) && ($mingrade<=0 || $maxgrade<=0)) ) {
			echo osa_ajaxmsg(lang('admin_benchmark_error_standard'));
		   exit();
		}

		$data = array();
	   $keys = array_keys($_POST);
		$type = '';

	   foreach ($keys as $key) {
	   	$lower_key = strtolower($key);
	   	if ( !in_array($lower_key, $this->allowed_post_keys) ) {
				continue;
			}
			$value = trim($_POST[$key]);
    	 	if ($lower_key == 'enabled') {
	    	  	if ($value == 'on')
	    		 	$value = 1;
	    		else
	    			$value = 0;
    	 	}
    	 	elseif ($lower_key == 'type') {
    	 		$type = $value;
    	 	}
    	 	/*
    	 	elseif ($this->config->item('cms_lt_importid_support') && $lower_key == 'importid') {
				if ( !empty($value) ) {
					$bigint = osa_dotnum2int($value);
					if ( $bigint !== FALSE ) {
						$data['importid_int'] = $bigint;
					}
				}
	      }*/
    		$data[$lower_key] = $value;
	   }
		$target = FALSE;
		$target['type'] = $type;
		$this->CI =  get_instance();
		//$divid = 'benchmark' ;
	   $temp = $this->CI->searchsort_model->getSort($this->divid);

	   //For ICT, GC and TaIL upload?
	   if (isset($temp->schoolflag) && $temp->schoolflag != FALSE ){
	   	$result=$this->benchmark_model->add_benchmark($data,$target);
	   }
	   else{
	   	$result=$this->benchmark_model->add_benchmark($data);
	   }

		if ($result==1)
			$result = 'success';
		echo $result;
	}

	function update() {
		$this->form_validation->set_rules('standardid', 'Standard', 'trim|required|is_numeric') ;
		$this->form_validation->set_rules('id', 'Current Benchmark', 'trim|required|is_numeric') ;
		$this->form_validation->set_rules('data', 'Data', 'trim|required') ;
		$this->form_validation->set_rules('mingradeid', 'Minimum Grade', 'trim') ;
		$this->form_validation->set_rules('maxgradeid', 'maximum Grade', 'trim') ;
		$run_result = $this->form_validation->run();

		$mingrade = set_value('mingradeid');
		$maxgrade = set_value('maxgradeid');
		if ( !$run_result || (is_numeric($maxgrade) && is_numeric($mingrade) && ($mingrade==0 || $maxgrade==0)) ) {
			echo osa_ajaxmsg(lang('admin_benchmark_error_standard'));
		   exit();
		}
		$data = array();
	   $keys = array_keys($_POST);
		$benchmarkid = set_value('id');

	   foreach ($keys as $key) {
	   	$lower_key = strtolower($key);
	   	if ( !in_array($lower_key, $this->allowed_post_keys) ) {
				continue;
			}
    	 	$value = trim($_POST[$key]);
    	 	$key = strtolower($key);
    	 	if ($lower_key == 'enabled') {
	    	  	if ($value == 'on')
	    		 	$value = 1;
	    		else
	    			$value = 0;
    	 	}
			/* elseif ( $this->config->item('cms_lt_importid_support') && $lower_key == 'importid' ) {
				$data['importid_int'] = NULL;
    			if ( !empty($value) ) {
					$bigint = osa_dotnum2int($value);
					if ( $bigint !== FALSE ) {
						$data['importid_int'] = $bigint;
					}
				}
    		} */
    		$data[$lower_key] = $value;
	   }

		$result=$this->benchmark_model->update_benchmark($benchmarkid,$data);
		if ($result==1)
			$result = 'success';
		echo $result;
	}

   function add($enableflag=FALSE) {
        $this->edit(FALSE, $enableflag, CMS_ADMIN_ADD);
	}

	function edit($benchmarkid, $list, $action=CMS_ADMIN_EDIT) {
		if ( is_numeric($list) == FALSE || $list < CMS_ADMIN_DISABLE || $list > CMS_ADMIN_ALL ) {
			// show error message
			echo 'error list';
			return FALSE;
		}
		$this->CI =  get_instance();
	   $data = FALSE;
		//$divid = 'benchmark' ;
	   $temp = $this->CI->searchsort_model->getSort($this->divid);
	   $data->page = $this->admin_base->getpage(CMS_ADMIN_BENCHMARK_TYPE);
      $data->selectlistitem = $list;
		$data->course = $this->benchmark_model->get_course();
	   $data->grade = $this->benchmark_model->get_grade();
	   $data->type = $temp->type;
	   $data->standard = $this->benchmark_model->get_standard($temp->type,$temp->selectid);
	   $data->update_div = $temp->refresh;
   	$data->divid = $temp->divid;
   	$data->action = $action;

   	$data->selectid = $temp->selectid;
   	if ($data->selectid ==FALSE || $data->selectid =='')
   		$data->selectid ='0';

   	$data->selectstandardid  = $temp->selectstandardid;
   	if ($data->selectstandardid ==FALSE || $data->selectstandardid =='')
   		$data->selectstandardid ='0';

   	$data->dep_schid = $temp->dep_schid;
   	if ($data->dep_schid ==FALSE || $data->dep_schid =='')
   		$data->dep_schid ='0';

   	$data->filter=$temp->filter;
   	 if ($temp->filter==FALSE && $temp->filter=='')
    		$data->filter = FALSE;
    	$_schoolflag = FALSE;
   	if (isset($temp->schoolflag) && $temp->schoolflag != FALSE)
    		$_schoolflag = $temp->schoolflag;
    	$_table = FALSE;
	  	if (isset ($temp->table) && $temp->table != FALSE)
	  		$_table = $temp->table;


	    if ($action == CMS_ADMIN_EDIT ) {
			$benchmark = $this->benchmark_model->get_benchmark($benchmarkid,1,FALSE,$_table);
			if ($benchmark == FALSE || count($benchmark)==0) {
				// show error message
				echo 'show error message: no data';
				return FALSE;
			}

   		$data->data = $benchmark;
   		$row= $benchmark[0];
   		$selected_course = $row->courseid;
   		$selected_gmin = $row->mingradeid;
   		$selected_gmax = $row->maxgradeid;
   		$selected_std = $row->standardid;
   		$selected_display = $row->data;
   		$data->strand_search   = $row->strand;
			if (isset($_schoolflag) && $_schoolflag != FALSE){
				$data->dep_sch = $row->school;
				$data->col_dep_sch = lang('admin_benchmark_col_school');
			}
			else{
				$data->dep_sch = $row->department;
				$data->col_dep_sch = lang('admin_benchmark_col_dep');
			}
	    }
	    elseif ($action == CMS_ADMIN_ADD ) {
    		$selected_course = $data->course[0];
   		$selected_gmin = $data->grade[0];
   		$selected_gmax = $data->grade[0];
   		$selected_std = $temp->selectstandardid;
   		$selected_display = lang('admin_benchmark_add_head');
			$row = lang('admin_strand_ddldefualt');
			if (isset($temp->strand_search[$data->selectid])){
	 			$row = $temp->strand_search[$data->selectid];
			}
			$data->strand_search = $row;

			if (isset($_schoolflag) && $_schoolflag != FALSE){
				$data->dep_sch   = $temp->dep_search;
				$data->col_dep_sch = lang('admin_standard_col_school');
			}
			else{
				$data->dep_sch   = $temp->dep_search;
				$data->col_dep_sch = lang('admin_standard_col_dep');
			}
	    }
	   $data->selected_course = $selected_course;
	   $data->selected_gmin = $selected_gmin;
	   $data->selected_gmax = $selected_gmax;
	   $data->selected_std = $selected_std;
	   $data->selected_display = $selected_display;
		$this->_truncate_standard_text($data->standard);
		$data->show_importid = FALSE;
		if ( $this->config->item('cms_lt_importid_support') ) {
			$data->show_importid = TRUE;
		}
	   $this->load->view('admin/benchmark_input_view',$data);
	}

	function delete($benchmarkid, $enabled, $enabledflag,$type) {
		if ( is_numeric($benchmarkid)==FALSE ||  is_numeric($enabled)==FALSE ||  is_numeric($enabledflag)==FALSE ) {
			// show error message
			echo 'error list';
			return FALSE;
		}

		if ( $enabled < CMS_ADMIN_DISABLE && $enabled > CMS_ADMIN_ENABLE ) {
			// show error message
			echo 'error list';
			return FALSE;
		}

		if ($enabled == CMS_ADMIN_DISABLE)
			$enabled = CMS_ADMIN_ENABLE;
		else
		    $enabled = CMS_ADMIN_DISABLE;

		$this->CI = get_instance();
		//$divid = 'benchmark' ;
		$benchmark = $this->CI->searchsort_model->getSort($this->divid);
	   $selectid = $benchmark->selectid;
	   $selectstandardid  = $benchmark->selectstandardid;
	   $dep_schid  = $benchmark->dep_schid;
	   $filter= FALSE;
	   if ($benchmark->filter!=FALSE && $benchmark->filter!='')
	   	$filter=$benchmark->filter;
		  if ($benchmark->refresh=='page_content'){
			  $this->benchmark_model->del_benchmark($benchmarkid, $enabled);
			  $this->refresh($enabledflag,$type,$benchmark->refresh,$dep_schid,$selectid,$selectstandardid,$filter);
		  }else{
				$result=$this->benchmark_model->del_benchmark($benchmarkid, $enabled);
			if ($result==1)
				$result =base_url().'admin/benchmark/refresh/'. $enabledflag.'/'.$type.'/'.$benchmark->refresh.'/'.$dep_schid.'/'.$selectid.'/'.$selectstandardid.'/'.$filter;
			echo $result;
		  }
	}

	/*
	function search() {
		$this->CI = get_instance();
		//$divid = 'benchmark' ;
		$benchmark = $this->CI->searchsort_model->getSort($this->divid);
	   $_type = $benchmark->type;
	   $page_con = '0';
	   $selectid = '0';
	   $selectstandardid = '0';
	   $dep_schid= '0';
	   if ($benchmark->dep_schid != FALSE && $benchmark->dep_schid != '')
	    	$dep_schid =	$benchmark->dep_schid;
	   if ($benchmark->selectid != FALSE && $benchmark->selectid != '')
	    	$selectid =	$benchmark->selectid;
	   if ($benchmark->selectstandardid != FALSE && $benchmark->selectstandardid != '')
	    	$selectstandardid = $benchmark->selectstandardid;
	   if ($benchmark->refresh != FALSE && $benchmark->refresh != '')
	    	$page_con =	$benchmark->refresh;

	    $keys = array_keys($_POST);
	    foreach ($keys as $key) {
	    	if ($key != 'bustcache') {
	    		$value = trim($_POST[$key]);
				if ($key == 'filter'){
					$filter = $value;
				}
				elseif ($key == 'filters'){
					$enableflag = $value;
				}
			}
	    }
    	echo $enableflag.'/'.$_type.'/'.$page_con.'/'.$dep_schid.'/'.$selectid.'/'.$selectstandardid.'/'.$filter;
	}
*/

	function search() {
		$this->access_model->checkaccess_any('admin_system_management');
		$this->load->library('search/searchutil');
		$display = & $this->searchutil->get_session($this->divid);
		//$display->selectlistitem = $enableflag;
		$filter = FALSE;
		if ( array_key_exists('filter', $_REQUEST) ) {
			$filter = $_REQUEST['filter'];
		}
		$this->refresh($display->selectlistitem, $display->type, 'page_content', $display->dep_schid,
							$display->selectid, $display->selectstandardid, $filter);
	}

	function filter() {
	 $keys = array_keys($_POST);
	    foreach ($keys as $key) {
	    	if ($key != 'bustcache') {
	    		$value = trim($_POST[$key]);
				if ($key == 'standardid'){
					$standardid = $value;
				}
				elseif ($key == 'id'){
					$enableflag = $value;
				}

			}
	    }
    	 $this->refresh($enableflag,FALSE,FALSE,$standardid);
	}

	private function _truncate_standard_text(&$array) {
		if ( is_array($array) ) {
			foreach ($array as $key=>$value) {
				if ( strlen($value) > 120) {
					$array[$key] = substr($value,0,119) . '...';
				}
			}
		}
	}
}
?>