<?php
/**
 * cms.php - Configurations for the CMS system
 *
 * @author $Author: wichai $
 * @version $Id: cms.php,v 1.147 2011/05/31 07:57:32 wichai Exp $
 * @copyright Copyright (c) 2009, Tiller Software Co., Ltd.
*/
if ( ! defined('BASEPATH')) exit('No direct script access allowed');

//Sets the parameters in database.php. password should be set in the site config
global $CMS_DB_USERNAME, $CMS_DB_PASSWORD, $CMS_DB_SCHEMA, $CMS_DB_ACTIVEGROUP, $CMS_DB_HOSTNAME;
global $g_sess_update, $g_sess_update_ignore_timer;

//Turn off all error messages for browser
error_reporting(0);
//We don't need magic quotes
@ini_set('magic_quotes_gpc', 0);

//Maintenance flag
$config['cms_manage_mode'] = FALSE;	//TRUE=In Maintenance mode, FALSE=Everyone can login

$CMS_DB_SCHEMA = 'cms';
$CMS_DB_USERNAME = 'cms';
$CMS_DB_HOSTNAME = 'localhost';
$CMS_DB_ACTIVEGROUP = 'production';

//This controls to update the session data or not
$g_sess_update = FALSE;
$g_sess_update_ignore_timer = FALSE; //Ignore the session activity timer

//////////////////////////////////////////////////////
//Application specific config
$config['cms_max_uploadsize'] = 8; //Have to set php.ini too
$config['cms_upload_timeout'] = 60*60; //One hour for upload
/* fixed in (issue: 215)
if ( isset($_SERVER['HTTP_USER_AGENT']) && stripos($_SERVER['HTTP_USER_AGENT'], 'chrome') != false) {
	//Chrome uses gears but Chrome 12 will not support gears
	$config['cms_plupload_runtimes'] = "gears,html5,html4,flash,browserplus";
}
*/
if (!isset($_SERVER['HTTP_USER_AGENT']) || (stripos($_SERVER['HTTP_USER_AGENT'], 'msie') === false)) {
	//Anything that is not IE or Chrome
	$config['cms_plupload_runtimes'] = "html5,html4,flash,gears,browserplus";
}
else {
	//Problem with html4 in IE so have to do this
	$config['cms_plupload_runtimes'] = "flash,silverlight,html5,html4,gears,browserplus";
}

$config['cms_pdf_max_timeout'] = 5*60; //5 minutes for PDF generation

//Use multiple display grades in menu or not
//$config['cms_multiple_display_grade'] = FALSE;
$config['cms_local_nologin_password'] = 'NO_LOGIN';

$config['cms_ajax_errortag'] = '<!---:ajproto_ERROR_TaG:--->';
$config['cms_ajax_redirecthometag'] = '<!---:ajproto_REDIRECTHOME_TaG:--->';
$config['cms_guest_username'] = 'guest';
$config['cms_admin_username'] = 'admin';
//Always set cms_use_all_unit_types to false when using
//cms_use_unit_meta, cms_use_unit_integrated, cms_use_unit_unified flags
//The unit flags are not set here so ther are always false unless defined in the school config file
$config['cms_use_all_unit_types'] = TRUE;
$config['cms_use_it_standard'] = TRUE;
$config['cms_login_title'] = 'Curriculum Mapping System Login';
$config['cms_survey_login_title'] = 'Survey System Login';
$config['cms_grade_table'] = 'display_grade'; //Use this table for display grade menu panel and searches

//Defines the mzximum number of selection boxes on the resource page
//$config['cms_max_selects'] = 4;
//fix ict/lib
$config['cms_max_selects'] = 8;
//Should override this in the site file to activate help button and define the help template
$config['cms_help_config'] = FALSE;
$config['cms_help_notree'] = FALSE;

//Defines the maximum number of rows per page
$config['cms_max_perpage']  = 35;
$config['cms_max_showpage'] =  4; //  left=4, right=4

//This flag tells to show the copy button under the course tree
$config['cms_unit_copyunit'] = TRUE;

//Course grade related flags
//This tells which table to use for the left panel display by grade tree
//We need this to support ISB since they will swicth to display_grade when the data is there
//$config['cms_grade_table'] = 'course_grade';
$config['cms_grade_table'] = 'display_grade';
//Can we select multiple grades on the course description page
$config['cms_multiple_grade_display'] = FALSE;
//Save grade selections from course desc page to this table
$config['cms_gradetable_2save'] = 'display_grade';
//Always show all grades based on mingrade and maxgrade on the course desc page
$config['cms_show_allgrades'] = FALSE;

$config['cms_pdf_exe'] = 'c:\windows\wkhtmltopdf.exe';
$config['cms_pdf_tmp_dir'] = 'c:\contents\cms\tmp\pdf\\';
$config['cms_pdf_exe_options'] = '-q -s A4 --encoding UTF8'; //default for Windows and Linux
$config['cms_pdf_exe_options_extra'] = '--zoom 1.4'; //Apply to Windows only

//unit compare config scroll, FALSE = single scroll
$config['cms_unitcompare_multi_scroll'] = FALSE;
//This many hours without edit page access will unlock the unit for other editors
//if multiple editors is enabled which is by default. Set it to FALSE will disable this time limit locking feature
//If this is greater than 24 then it has to be a multiply of 24
$config['cms_unitlock_hour_expire'] = 8;

/* Defines what grade levels have what unit type add links, if not defined then all links are avaibale
$config['cms_unit_templates'] =
	array(1=>array('pyp','ubd'), 2=>array('pyp','ubd'), 3=>array('pyp','ubd'), 4=>array('pyp','ubd'),
		   5=>array('pyp','ubd'), 6=>array('myp','ubd'), 7=>array('myp','ubd'), 8=>array('myp','ubd'), 9=>array('ubd'),
		   10=>array('ubd'), 11=>array('ubd'), 12=>array('ubd'), 13=>array('pyp','ubd'), 14=>array('pyp','ubd'), 15=>array('pyp','ubd')); */
//Unit type language translation
$config['cms_unittype_translate'] = array('ubd' => array('UbD', 'UbD Unit'), 'myp' => array('MYP', 'MYP Unit'), 'pyp' => array('PYP', 'PYP UoI'));
//$config hidden (title,team_member) from goal with view pdf
$config['cms_goal_mode'] = FALSE; //for use goal button
$config['cms_hidden_goal_title_pdf'] = TRUE;
$config['cms_multi_goals'] = TRUE;
$config['cms_goal_user_title'] = TRUE;
$config['cms_goal_multi_editor'] = TRUE;
$config['cms_goal_show_editorbox'] = FALSE;
$config['cms_goal_menu_help'] = TRUE;
$config['cms_goal_admin_stage_editor_support'] = FALSE;

//Maximum number of empty URLs on the resource popup
$config['cms_max_multi_url'] = 2;
//Session related configs
$config['cms_sess_time_to_update'] =  10 * 60 * 1000; // 10 minute update interval
$config['cms_sess_expiration'] = 1000 * 3600 * 1000; // 1000 hours becuase we try to prevent problem with 2 browsers
																	  // actual timeout comes from the server now
$config['cms_header_footer_create_folder'] = 'misc/pdftemp/';
$config['cms_header_filename'] = 'header';
$config['cms_footer_filename'] = 'footer';
$config['cms_pdf_header'] ="-T 20 --header-spacing 1 --header-html ";
$config['cms_pdf_footer'] = "-B 20 --footer-html ";
$config['cms_survey_blocks'] = array(1=>'A',2=>'B',3=>'C',4=>'D',5=>'E',6=>'F',7=>'G',8=>'H');
$config['cms_survey_ldap_attr_translate'] = array('ext_username' => 'samaccountname', 'ext_firstname' => 'givenname',
																  'ext_lastname' => 'sn', 'ext_email' => 'mail');
/*
	This overrides the refresh URL based on the template file. This was done for the system
	templates but this can be applied to any other templates.
	The system templates are filename part based, others are templateid based
*/
$config['cms_stage_refresh_url_config'] =
	array( 'course_desc' => 'course/desc/stage',
			 'unit' => 'unit/unit/stage',
			 'goal' => 'goal/goal/stage',
			 'survey' => 'survey/survey/stage',
			 'site_resources' => 'cms/site_res/stage',
	);

//Make all the image and include paths dynamic so we can manipulate them if necessary
$config['cms_app_include_folder'] = 'include';
$config['cms_top_image_folder'] = 'images';
$config['cms_site_image_folder'] = 'site'; //This would be images/site | images/site_old
//Sets the skin for dhtmlxwindows - dhx_blue, dhx_skyblue, dhx_black, dhx_web/(does not work in IE)
$config['cms_dhtmlxwindows_skin'] = 'dhx_skyblue';
//Add extra pixels to the height of all windows
$config['cms_dhtmlxwindows_extraheight'] = 70;
//(issue: 136) This will cause all the mapping searches to use the same divid/window and session result
$config['cms_mapping_divid'] = 'mappingsinglewindow';
//Compress all PHP search sessions
$config['cms_searchsession_compress'] = TRUE;
//Size in bytes, to compress if larger than this
$config['cms_searchsession_compress_threshold'] = 50000;
//divids/session_names not  belonging to the mapping searches.
/* $config['cms_mapping_nosearch_sessions'] =
   array('goal', 'adminsavesession', 'eq', 'strand', 'standard', 'benchmark'); */
   //array('user', 'course', 'department', 'strand', 'standard', 'benchmark', 'eq', 'goal', 'adminsavesession');
$config['cms_pdf_private_resource_select'] = FALSE;
//Admin note section in unit page
$config['cms_unit_admin_note_support'] = FALSE;
//DB prefetch. Should be always on unless problem in prefetch.
$config['cms_db_prefetch_enable'] = TRUE;
$config['cms_db_prefetch_enable_btnsort'] = TRUE;
$config['cms_db_prefetch_enable_resource'] = TRUE;
//The login page msg from maintenance files.
$config['cms_login_message'] = FALSE;
//To enable failed login lockout feature
$config['cms_failed_login_lockout_check'] = TRUE;

//For development purpose, not used in production
//@include_once('cms_development.php');

if ( !isset($skip_config_for_cms_development) || !$skip_config_for_cms_development ) {
	//The config file generated by the web installation utility
	//This overrides everything except the config stored in database
	$local_config_exists = @include(FCPATH . 'config.php');
	require_once(FCPATH . 'templates/siteconfig/' . $config['cms_unit_org'] . '.php');
	if ( $local_config_exists ) {
		//Include this again to overwrite siteconfig
		//Have to include twice so we know what cms_unit_org it is above
		@include(FCPATH . 'config.php');
	}

	//Needs site URL first so has to be after the site specific config. Only config if not done in site config
	//The Mimtex math formula image generator. A CGI has to be configured on every server
	if ( !array_key_exists('cms_html_cgi_bin', $config)) {
		$config['cms_html_cgi_bin'] = "{$config['base_url']}cgi-bin/mimetex.exe";
	}
}
$config['cms_help_path'] = 'misc/help/';
$config['cms_svg_graph']      = "misc/php/svg/svgimg.php";
//$config['cms_svg_graph_file'] = "{$config['cms_app_include_folder']}/js/tiny_mce/plugins/asciisvg/js/d.svg";
//This one is special since every graph will save the path to d.svg in the include folder
//Have to make it static and always in include
$config['cms_svg_graph_file'] = 'include/js/tiny_mce/plugins/asciisvg/js/d.svg';
$config['cms_svg_graph_css']  = "{$config['cms_app_include_folder']}/css/svggraph.css";

//Set cookie path. This is necessary if TODCM is not installed on the web server root folder.
//This makes the sub folders have their own session cookies
$cookie_path = '/';
$script_name = $_SERVER['SCRIPT_NAME'];
if ( !empty($script_name) ) {
	$last_pos = stripos($script_name, 'index.php');
	$urlpart = @substr($script_name, 0, $last_pos);
	if ( !empty($urlpart) && strlen($urlpart) > 2 ) {
		//minimum length is 3 - /a/
		$cookie_path = $urlpart;
	}
}
$config['cookie_path'] = $cookie_path;
