<?php
/**
 * view_requirements.php - Failed requirements
 *
 * @author $Author: dtong $
 * @version $Id: view_requirements.php,v 1.8 2011/04/15 11:46:09 dtong Exp $
 * @copyright Copyright (c) 2011, Tiller Software Co., Ltd.
*/
if (!defined('INSTALL_PROCESS')) exit('No direct script access allowed');
$json_data = rawurlencode(json_encode($data));
$phpinfo = '<a target="install_phpinfo" href=index.php?cmd=10>Click to see PHP Info</a>';
?>
<form method="post" name="install_form">
	<input type="hidden" name="cmd" value="<?php echo CMD_DB_SETTINGS?>" />
	<input type="hidden" name="data" value="<?php echo $json_data?>" />
<center>
<div>
<fieldset style="width:700px;text-align:left;margin:20px"><legend>Installation Requirements Checklist (Step 1 of <?php echo TOTAL_STEPS?>)</legend>
<div style="margin-left:50px">
Components required for the installation:<br />
<table width="600" border="1" cellspacing="1" cellpadding="10">

	<tr>
		<td>
			1. Apache Web Server
			<?php
				if ($result['apache'] == CHECK_FAILED_HTML) {
					echo '<br />&nbsp;&nbsp;&nbsp;&nbsp;<font color="red">Only the Apache web server is supported.
							This and all other Apache related checks will fail if you are running PHP as a CGI.</font>';
				}
			?>
		</td>
		<td><?php echo $result['apache']?></td>
	</tr>
	<tr>
		<td>
			2. Apache Rewrite Module
			<?php
				if ($result['apache_rewrite'] == CHECK_FAILED_HTML) {
					echo '<div class="req_failed">
						Please turn on the Apache rewrite module by adding or uncommenting the
						following line to the Apache configuration file (make sure to restart Apache afterward):<br />
						<div class="req_failed">LoadModule rewrite_module modules/mod_rewrite.so</div>
						</div>';
				}
			?>
		</td>
		 <td><?php echo $result['apache_rewrite']?></td></tr>
	<tr>
		<td>
			3. PHP Version (Only 5.2.x and 5.3.x are supported. 5.1.x should work with additional PHP JSON extension)
			<?php
				if ($result['php_version'] == CHECK_FAILED_HTML) {
					echo '<div class="req_failed">You are running PHP version ' . phpversion() . ", ${phpinfo}.</div>";
				}
			?>
		</td>
		<td><?php echo $result['php_version']?></td>
	</tr>
	<tr>
		<td>
			4. PHP MySQL Extension
			<?php
				if ($result['mysql'] == CHECK_FAILED_HTML) {
					echo "<div class=\"req_failed\">MySQL extension is missing. Please install the PHP MySQL extension, ${phpinfo}. " .
						  "You might need to set extension_dir=\"FULL_EXTENSION_PATH\" (replace FULL_EXTENSION_PATH with actual path such as c:/windows/php/ext) or add/uncomment extension=php_mysql.dll in your php configuration file</div>";
				}
			?>
		</td>
		<td><?php echo $result['mysql']?></td>
	</tr>
	<tr>
		<td>
			5. Website Folder "<?php echo $web_folder?>" Write Access
			<?php
				if ($result['web_write'] == CHECK_FAILED_HTML) {
					echo '<div class="req_failed">Please make folder ' . $web_folder . ' and all its sub-folders writable for the Apache server process. ' .
						  "For Linux, run \"chown -R apache {$web_folder}\" (assumes user apache owns the httpd processes) as the Linux root user.</div>";
				}
			?>
		</td>
		<td><?php echo $result['web_write']?></td>
	</tr>
	</table>
	<font size="-2">The installation can not be continued if any one of the above fails.</font>
	<br />
	<br />

	Optional Requirements:<br />
	<table width="600" border="1" cellspacing="1" cellpadding="10">
	<tr>
		<td>
			1. OS Support (Linux, Mac OS-X and Windows)
			<?php
				 if ($result['os'] == CHECK_FAILED_HTML) {
					echo '<div class="req_failed">Your Operating System: ' . php_uname('s') . '</div>';
				}
			?>
		</td>
		<td><?php echo $result['os']?></td>
	</tr>
	<tr>
		<td>
			2. WKHTMLTOPDF Binary Support (PDF generator, OS dependent)
			<?php
				 if ($result['pdf'] == CHECK_FAILED_HTML) {
					echo '<div class="req_failed">Sorry, we have to disable PDF generation because your OS ('  . php_uname('m') . ') is not supported.</div>';
				}
			?>
		</td>
		<td><?php echo $result['pdf']?></td>
	</tr>
	<tr>
		<td>
			3. MIMETEX Binary Support (Math formula image generator, OS dependent)
			<?php
				 if ($result['mimetex'] == CHECK_FAILED_HTML) {
					echo '<div class="req_failed">Sorry, we have to disable math formula image generation because your OS ('  . php_uname('m') . ') is not supported.</div>';
				}
			?>
		</td>
		<td><?php echo $result['mimetex']?></td>
	</tr>
	<tr>
		<td>
			4. PHP Config File - Upload Size (<?php echo DEFAULT_UPLOAD_SIZE_MB?> MB recommended)
			<?php
				 if ($result['upload'] == CHECK_FAILED_HTML) {
					echo '<div class="req_failed">Your upload size will be limited by the smaller of these 2 settings in your PHP config file:' .
						  '<div class="req_failed">post_max_size = ' . ini_get('post_max_size') . '</div>' .
						  '<div class="req_failed">upload_max_filesize = ' . ini_get('upload_max_filesize') . '</div>' .
						  '</div>';
				}
			?>
		</td>
		<td><?php echo $result['upload']?></td>
	</tr>
	<tr>
		<td>
			5. Apache Deflate/Compression Module (Makes pages load faster from internet)
			<?php
				 if ($result['apache_deflate'] == CHECK_FAILED_HTML) {
					echo '<div class="req_failed">Please add or uncomment the following line to the Apache configuration file:
							<div class="req_failed">LoadModule deflate_module modules/mod_deflate.so</div></div>';
				}
			?>
		</td>
		<td><?php echo $result['apache_deflate']?></td>
	</tr>
	<tr>
		<td>
			6. CGI-bin Support (For MIMETEX)
			<?php
				 if ($result['cgi_path'] == CHECK_FAILED_HTML) {
					echo '<div class="req_failed">Please check your Apache configuration and turn on CGI support.</div>';
				}
			?>
		</td>
		<td><?php echo $result['cgi_path']?></td>
	</tr>
	<tr>
		<td>
			7. CGI-bin Folder <?php if ($path) echo "\"$path\""?> Write Access (For copying the MIMETEX binary)
		</td>
		<td><?php echo $result['cgi_write']?></td>
	</tr>
</table>
</div>
<div style="margin-top:10px">
	<input type="submit" name="recheck" value="Recheck" class="btn"
			 onmouseout="if(this.className) this.className='btn';"
			 onmouseover="if(this.className) this.className='btnhov';"
			 onClick="install_form.cmd.value='<?php echo CMD_CHECK_REQUIREMENTS?>'; install_form.submit();return false;" />
	<input <?php echo $disabled?> type="submit" name="next" value="Next" class="btn"
			 onmouseout="if(this.className) this.className='btn';"
			 onmouseover="if(this.className) this.className='btnhov';" />
	<?php if ( !empty($disabled) ) { ?>
		<input type="submit" name="continue" value="Continue Anyway" class="btn"
			 onmouseout="if(this.className) this.className='btn';"
			 onmouseover="if(this.className) this.className='btnhov';" />
	<?php } ?>
</div>
</fieldset>
</div>
</center>
</form>